/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.view;

import java.util.Locale;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class CrafterCacheAwareViewResolverDecorator
implements ViewResolver,
Ordered {
    private static final String VIEW_CONST_KEY_ELEM = "view";
    protected int order;
    protected ViewResolver actualViewResolver;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Required
    public void setActualViewResolver(ViewResolver actualViewResolver) {
        this.actualViewResolver = actualViewResolver;
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            try {
                return (View)siteContext.getCacheTemplate().getObject(siteContext.getContext(), () -> {
                    try {
                        return this.actualViewResolver.resolveViewName(viewName, locale);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, new Object[]{viewName, locale, VIEW_CONST_KEY_ELEM});
            }
            catch (RuntimeException e) {
                throw (Exception)e.getCause();
            }
        }
        return this.actualViewResolver.resolveViewName(viewName, locale);
    }
}

