/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.view.freemarker;

import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.craftercms.engine.util.spring.ApplicationContextAccessor;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class AllHttpScopesAndAppContextHashModel
extends SimpleHash {
    private ApplicationContextAccessor applicationContextAccessor;
    private ServletContext context;
    private HttpServletRequest request;
    private boolean disableVariableRestrictions;

    public AllHttpScopesAndAppContextHashModel(ObjectWrapper wrapper, ApplicationContextAccessor applicationContextAccessor, ServletContext context, HttpServletRequest request, boolean disableVariableRestrictions) {
        super(wrapper);
        this.applicationContextAccessor = applicationContextAccessor;
        this.context = context;
        this.request = request;
        this.disableVariableRestrictions = disableVariableRestrictions;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        TemplateModel model = super.get(key);
        if (model != null) {
            return model;
        }
        Object obj = this.request.getAttribute(key);
        if (obj != null) {
            return this.wrap(obj);
        }
        HttpSession session = this.request.getSession(false);
        if (session != null && (obj = session.getAttribute(key)) != null) {
            return this.wrap(obj);
        }
        if (this.disableVariableRestrictions && (obj = this.context.getAttribute(key)) != null) {
            return this.wrap(obj);
        }
        try {
            return this.wrap(this.applicationContextAccessor.get(key));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return this.wrap(null);
        }
    }
}

