/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.repository;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.to.RemoteRepositoryInfoTO;
import org.craftercms.studio.api.v1.to.VersionTO;

public interface ContentRepository {
    public boolean contentExists(String var1, String var2);

    public InputStream getContent(String var1, String var2) throws ContentNotFoundException, CryptoException;

    public long getContentSize(String var1, String var2);

    public String writeContent(String var1, String var2, InputStream var3) throws ServiceLayerException;

    public String createFolder(String var1, String var2, String var3);

    public String deleteContent(String var1, String var2, String var3);

    default public Map<String, String> moveContent(String site, String fromPath, String toPath) {
        return this.moveContent(site, fromPath, toPath, null);
    }

    public Map<String, String> moveContent(String var1, String var2, String var3, String var4);

    public String copyContent(String var1, String var2, String var3);

    public RepositoryItem[] getContentChildren(String var1, String var2);

    public VersionTO[] getContentVersionHistory(String var1, String var2);

    public String createVersion(String var1, String var2, boolean var3);

    public String createVersion(String var1, String var2, String var3, boolean var4);

    public String revertContent(String var1, String var2, String var3, boolean var4, String var5);

    public InputStream getContentVersion(String var1, String var2, String var3) throws ContentNotFoundException;

    public void lockItem(String var1, String var2);

    public void lockItemForPublishing(String var1, String var2);

    public void unLockItem(String var1, String var2);

    public void unLockItemForPublishing(String var1, String var2);

    public boolean deleteSite(String var1);

    public void initialPublish(String var1, String var2, String var3, String var4, String var5) throws DeploymentException, CryptoException;

    public String getRepoLastCommitId(String var1);

    public String getRepoFirstCommitId(String var1);

    public List<String> getEditCommitIds(String var1, String var2, String var3, String var4);

    public void insertFullGitLog(String var1, int var2);

    public void deleteGitLogForSite(String var1);

    public boolean createSitePushToRemote(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, boolean var9) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, RemoteRepositoryNotBareException, ServiceLayerException;

    public boolean addRemote(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws InvalidRemoteUrlException, ServiceLayerException;

    public void removeRemoteRepositoriesForSite(String var1);

    public List<RemoteRepositoryInfoTO> listRemote(String var1, String var2) throws ServiceLayerException, CryptoException;

    public boolean pushToRemote(String var1, String var2, String var3) throws ServiceLayerException, InvalidRemoteUrlException, CryptoException;

    public boolean pullFromRemote(String var1, String var2, String var3) throws ServiceLayerException, InvalidRemoteUrlException, CryptoException;

    public boolean isFolder(String var1, String var2);

    public void resetStagingRepository(String var1) throws ServiceLayerException, CryptoException;

    public void reloadRepository(String var1);

    public void cleanupRepositories(String var1);
}

