/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.service.objectstate;

import java.util.Arrays;
import java.util.List;

public enum State {
    NEW_UNPUBLISHED_LOCKED("New Unpublished Locked"),
    NEW_UNPUBLISHED_UNLOCKED("New Unpublished Unlocked"),
    NEW_SUBMITTED_WITH_WF_SCHEDULED("New Submitted with Workflow Scheduled"),
    NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED("New Submitted with Workflow Scheduled Locked"),
    NEW_SUBMITTED_WITH_WF_UNSCHEDULED("New Submitted with Workflow Unscheduled"),
    NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED("New Submitted with Workflow Unscheduled Locked"),
    NEW_SUBMITTED_NO_WF_SCHEDULED("New Submitted without Workflow Scheduled"),
    NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED("New Submitted without Workflow Scheduled Locked"),
    NEW_SUBMITTED_NO_WF_UNSCHEDULED("New Submitted without Workflow Unscheduled"),
    NEW_PUBLISHING_FAILED("New Publishing Failed"),
    NEW_DELETED("New Deleted"),
    EXISTING_UNEDITED_LOCKED("Existing Unedited Locked"),
    EXISTING_UNEDITED_UNLOCKED("Existing Unedited Unlocked"),
    EXISTING_EDITED_LOCKED("Existing Edited Locked"),
    EXISTING_EDITED_UNLOCKED("Existing Edited Unlocked"),
    EXISTING_SUBMITTED_WITH_WF_SCHEDULED("Existing Submitted with Workflow Scheduled"),
    EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED("Existing Submitted with Workflow Scheduled Locked"),
    EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED("Existing Submitted with Workflow Unscheduled"),
    EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED("Existing Submitted with Workflow Unscheduled Locked"),
    EXISTING_SUBMITTED_NO_WF_SCHEDULED("Existing Submitted without Workflow Scheduled"),
    EXISTING_SUBMITTED_NO_WF_SCHEDULED_LOCKED("Existing Submitted without Workflow Scheduled Locked"),
    EXISTING_SUBMITTED_NO_WF_UNSCHEDULED("Existing Submitted without Workflow Unscheduled"),
    EXISTING_PUBLISHING_FAILED("Existing Publishing Failed"),
    EXISTING_DELETED("Existing Deleted"),
    SYSTEM_PROCESSING("System Processing"),
    NOOP("INVALID STATE");

    private final String label;
    public static final List<State> NEW_STATES;
    public static final List<State> DELETED_STATES;
    public static final List<State> EDITED_STATES;
    public static final List<State> SUBMITTED_STATES;
    public static final List<State> SCHEDULED_STATES;
    public static final List<State> LOCKED_STATES;
    public static final List<State> IN_PROGRESS_STATES;
    public static final List<State> CHANGE_SET_STATES;
    public static final List<State> LIVE_STATES;
    public static final List<State> PUBLISHING_FAILED;
    public static final List<State> WORKFLOW_STATES;

    private State(String label) {
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    public static final boolean isNew(State state) {
        return NEW_STATES.contains((Object)state);
    }

    public static boolean isDeleted(State state) {
        return DELETED_STATES.contains((Object)state);
    }

    public static boolean isUpdateOrNew(State state) {
        return EDITED_STATES.contains((Object)state) || NEW_STATES.contains((Object)state);
    }

    public static boolean isUpdated(State state) {
        return EDITED_STATES.contains((Object)state);
    }

    public static boolean isSubmitted(State state) {
        return SUBMITTED_STATES.contains((Object)state);
    }

    public static boolean isScheduled(State state) {
        return SCHEDULED_STATES.contains((Object)state);
    }

    public static boolean isLocked(State state) {
        return LOCKED_STATES.contains((Object)state);
    }

    public static boolean isLive(State state) {
        return LIVE_STATES.contains((Object)state);
    }

    public static boolean isSubmittedForDeletion(State state) {
        return DELETED_STATES.contains((Object)state);
    }

    public static boolean isSystemProcessing(State state) {
        return SYSTEM_PROCESSING.equals((Object)state);
    }

    public static boolean isPublishingFailed(State state) {
        return PUBLISHING_FAILED.contains((Object)state);
    }

    public static boolean isInWorkflow(State state) {
        return WORKFLOW_STATES.contains((Object)state);
    }

    public static boolean isUpdateOrSubmitted(State state) {
        return EDITED_STATES.contains((Object)state) || SUBMITTED_STATES.contains((Object)state);
    }

    static {
        NEW_STATES = Arrays.asList(NEW_UNPUBLISHED_LOCKED, NEW_UNPUBLISHED_UNLOCKED, NEW_SUBMITTED_WITH_WF_SCHEDULED, NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, NEW_SUBMITTED_NO_WF_SCHEDULED, NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED, NEW_SUBMITTED_NO_WF_UNSCHEDULED, NEW_PUBLISHING_FAILED, NEW_DELETED);
        DELETED_STATES = Arrays.asList(NEW_DELETED, EXISTING_DELETED);
        EDITED_STATES = Arrays.asList(EXISTING_EDITED_LOCKED, EXISTING_EDITED_UNLOCKED);
        SUBMITTED_STATES = Arrays.asList(NEW_SUBMITTED_WITH_WF_SCHEDULED, NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED);
        SCHEDULED_STATES = Arrays.asList(NEW_SUBMITTED_WITH_WF_SCHEDULED, NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, NEW_SUBMITTED_NO_WF_SCHEDULED, NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, EXISTING_SUBMITTED_NO_WF_SCHEDULED, EXISTING_SUBMITTED_NO_WF_SCHEDULED_LOCKED);
        LOCKED_STATES = Arrays.asList(NEW_UNPUBLISHED_LOCKED, NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED, EXISTING_UNEDITED_LOCKED, EXISTING_EDITED_LOCKED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, EXISTING_SUBMITTED_NO_WF_SCHEDULED_LOCKED);
        IN_PROGRESS_STATES = Arrays.asList(NEW_UNPUBLISHED_LOCKED, NEW_UNPUBLISHED_UNLOCKED, NEW_SUBMITTED_WITH_WF_SCHEDULED, NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, NEW_PUBLISHING_FAILED, NEW_DELETED, EXISTING_EDITED_LOCKED, EXISTING_EDITED_UNLOCKED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, EXISTING_PUBLISHING_FAILED, EXISTING_DELETED);
        CHANGE_SET_STATES = Arrays.asList(NEW_UNPUBLISHED_LOCKED, NEW_UNPUBLISHED_UNLOCKED, NEW_SUBMITTED_WITH_WF_SCHEDULED, NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, NEW_SUBMITTED_NO_WF_SCHEDULED, NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED, NEW_SUBMITTED_NO_WF_UNSCHEDULED, NEW_PUBLISHING_FAILED, NEW_DELETED, EXISTING_EDITED_LOCKED, EXISTING_EDITED_UNLOCKED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, EXISTING_SUBMITTED_NO_WF_SCHEDULED, EXISTING_SUBMITTED_NO_WF_SCHEDULED_LOCKED, EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, EXISTING_PUBLISHING_FAILED, EXISTING_DELETED);
        LIVE_STATES = Arrays.asList(EXISTING_UNEDITED_LOCKED, EXISTING_UNEDITED_UNLOCKED, NEW_DELETED);
        PUBLISHING_FAILED = Arrays.asList(NEW_PUBLISHING_FAILED, EXISTING_PUBLISHING_FAILED);
        WORKFLOW_STATES = Arrays.asList(NEW_SUBMITTED_WITH_WF_SCHEDULED, NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED, NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, NEW_SUBMITTED_NO_WF_SCHEDULED, NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED, NEW_SUBMITTED_NO_WF_UNSCHEDULED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED, EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, EXISTING_SUBMITTED_NO_WF_SCHEDULED, EXISTING_SUBMITTED_NO_WF_SCHEDULED_LOCKED, EXISTING_SUBMITTED_NO_WF_UNSCHEDULED);
    }
}

