/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.service.security;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserExternallyManagedException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.impl.v2.service.security.Authentication;

public interface SecurityService {
    public static final String STUDIO_SESSION_TOKEN_ATRIBUTE = "studioSessionToken";

    public String authenticate(String var1, String var2) throws Exception;

    public String getCurrentUser();

    public String getCurrentToken();

    public Authentication getAuthentication();

    public Set<String> getUserRoles(String var1);

    public Set<String> getUserRoles(String var1, String var2);

    public Set<String> getUserRoles(String var1, String var2, boolean var3);

    public Map<String, Object> getUserProfile(String var1) throws ServiceLayerException, UserNotFoundException;

    public Map<String, Object> getUserProfileByGitName(String var1) throws ServiceLayerException, UserNotFoundException;

    public Set<String> getUserPermissions(String var1, String var2, List<String> var3);

    public Set<String> getUserPermissions(String var1, String var2, String var3, List<String> var4);

    public boolean validateTicket(String var1);

    public void reloadConfiguration(String var1);

    public void reloadGlobalConfiguration();

    public boolean logout() throws SiteNotFoundException;

    public boolean userExists(String var1) throws ServiceLayerException;

    public int getAllUsersTotal() throws ServiceLayerException;

    public boolean validateToken(String var1) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException;

    public boolean changePassword(String var1, String var2, String var3) throws UserNotFoundException, PasswordDoesNotMatchException, UserExternallyManagedException, ServiceLayerException;

    public Map<String, Object> setUserPassword(String var1, String var2) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException;

    public boolean resetPassword(String var1, String var2) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException;

    public boolean validateSession(HttpServletRequest var1) throws ServiceLayerException;

    public boolean isSiteAdmin(String var1, String var2);
}

