/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.service.site;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.BlueprintNotFoundException;
import org.craftercms.studio.api.v1.exception.DeployerTargetException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.SiteCreationException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.service.site.SiteConfigNotFoundException;
import org.craftercms.studio.api.v1.to.RemoteRepositoryInfoTO;
import org.craftercms.studio.api.v1.to.SiteBlueprintTO;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.GitLog;
import org.craftercms.studio.api.v2.exception.MissingPluginParameterException;
import org.dom4j.Document;

public interface SiteService {
    public boolean writeConfiguration(String var1, String var2, InputStream var3) throws ServiceLayerException;

    public boolean writeConfiguration(String var1, InputStream var2) throws ServiceLayerException;

    public Document getSiteConfiguration(String var1) throws SiteConfigNotFoundException;

    public Map<String, Object> getConfiguration(String var1);

    public Map<String, Object> getConfiguration(String var1, String var2, boolean var3);

    public Set<String> getAllAvailableSites();

    public int countSites();

    public void createSiteFromBlueprint(String var1, String var2, String var3, String var4, String var5, Map<String, String> var6, boolean var7) throws SiteAlreadyExistsException, SiteCreationException, DeployerTargetException, BlueprintNotFoundException, MissingPluginParameterException;

    public void createSiteWithRemoteOption(String var1, String var2, String var3, String var4, String var5, String var6, String var7, boolean var8, String var9, String var10, String var11, String var12, String var13, String var14, Map<String, String> var15, boolean var16) throws ServiceLayerException, InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, RemoteRepositoryNotBareException, InvalidRemoteUrlException;

    public boolean deleteSite(String var1);

    @RetryingOperation
    public void updateLastVerifiedGitlogCommitId(String var1, String var2);

    public void updateLastSyncedGitlogCommitId(String var1, String var2);

    @ValidateParams
    public boolean syncDatabaseWithRepoUnprocessedCommits(@ValidateStringParam(name="site") String var1, List<GitLog> var2) throws SiteNotFoundException, IOException;

    public boolean syncDatabaseWithRepo(String var1, String var2) throws SiteNotFoundException;

    public boolean syncDatabaseWithRepo(String var1, String var2, boolean var3) throws SiteNotFoundException;

    public SiteBlueprintTO[] getAvailableBlueprints();

    public void reloadSiteConfigurations();

    public void reloadSiteConfiguration(String var1);

    public void reloadSiteConfiguration(String var1, boolean var2);

    public void reloadGlobalConfiguration();

    public void syncRepository(String var1) throws SiteNotFoundException;

    public void rebuildDatabase(String var1);

    public void updateLastCommitId(String var1, String var2);

    public boolean exists(String var1);

    public boolean existsById(String var1);

    public boolean existsByName(String var1);

    public int getSitesPerUserTotal() throws UserNotFoundException, ServiceLayerException;

    public int getSitesPerUserTotal(String var1) throws UserNotFoundException, ServiceLayerException;

    public List<SiteFeed> getSitesPerUser(int var1, int var2) throws UserNotFoundException, ServiceLayerException;

    public List<SiteFeed> getSitesPerUser(String var1, int var2, int var3) throws UserNotFoundException, ServiceLayerException;

    public SiteFeed getSite(String var1) throws SiteNotFoundException;

    public boolean isPublishingEnabled(String var1);

    public boolean enablePublishing(String var1, boolean var2) throws SiteNotFoundException;

    public boolean updatePublishingStatusMessage(String var1, String var2, String var3) throws SiteNotFoundException;

    public boolean addRemote(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws InvalidRemoteUrlException, ServiceLayerException;

    public boolean removeRemote(String var1, String var2) throws SiteNotFoundException;

    public List<RemoteRepositoryInfoTO> listRemote(String var1) throws ServiceLayerException, CryptoException;

    public List<SiteFeed> getDeletedSites();

    public boolean tryLockPublishingForSite(String var1, String var2, int var3);

    public boolean unlockPublishingForSite(String var1, String var2);

    public void updatePublishingLockHeartbeatForSite(String var1);

    public String getLastCommitId(String var1);

    public String getSiteState(String var1);

    public String getLastVerifiedGitlogCommitId(String var1);

    public List<String> getAllCreatedSites();

    public void setSiteState(String var1, String var2);

    public boolean isPublishedRepoCreated(String var1);

    public void setPublishedRepoCreated(String var1);

    public String getLastSyncedGitlogCommitId(String var1);
}

