/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.util;

import javax.servlet.http.HttpServletRequest;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v1.job.CronJobContext;
import org.craftercms.studio.api.v1.log.Logger;

public class DebugUtils {
    public static void addDebugStack(Logger logger) {
        if (logger.getLevel().equals("debug")) {
            Thread thread = Thread.currentThread();
            String threadName = thread.getName();
            logger.debug("Thread: " + threadName, new Object[0]);
            StackTraceElement[] stackTraceElements = thread.getStackTrace();
            StringBuilder sbStack = new StringBuilder();
            int stackSize = 20 < stackTraceElements.length - 2 ? 20 : stackTraceElements.length;
            for (int i = 2; i < stackSize + 2; ++i) {
                sbStack.append("\n\t").append(stackTraceElements[i].toString());
            }
            RequestContext context = RequestContext.getCurrent();
            CronJobContext cronJobContext = CronJobContext.getCurrent();
            if (context != null) {
                HttpServletRequest request = context.getRequest();
                String url = request.getRequestURI() + "?" + request.getQueryString();
                logger.debug("Http request: " + url, new Object[0]);
            } else if (cronJobContext != null) {
                logger.debug("Cron Job", new Object[0]);
            }
            logger.debug("Stack trace (depth 20): " + sbStack.toString(), new Object[0]);
        }
    }
}

