/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v1.util.filter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.craftercms.studio.api.v1.service.ServicesManager;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.util.filter.DmFilterWrapper;
import org.craftercms.studio.api.v1.util.filter.Filter;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class DmFilterWrapperImpl
implements DmFilterWrapper {
    protected Map<String, Filter> _filterMap;
    protected Filter _defaultFilter;
    protected ServicesManager servicesManager;
    protected ServicesConfig servicesConfig;

    public Map<String, Filter> getFilterMap() {
        return this._filterMap;
    }

    public void setFilterMap(Map<String, Filter> filterMap) {
        this._filterMap = filterMap;
    }

    public Filter getDefaultFilter() {
        return this._defaultFilter;
    }

    public void setDefaultFilter(Filter defaultFilter) {
        this._defaultFilter = defaultFilter;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    @Override
    public boolean accept(ContentItemTO item, String filterType) {
        if (item != null) {
            Filter filter = this.getFilter(filterType);
            return filter.filter(item);
        }
        return false;
    }

    @Override
    public boolean accept(String site, ContentItemTO item, String filterType) {
        if (item != null) {
            return this.accept(site, item.uri, filterType);
        }
        return false;
    }

    protected Filter getFilter(String filterType) {
        Filter filter = this._defaultFilter;
        if (filterType != null && this._filterMap.get(filterType.toLowerCase()) != null) {
            filter = this._filterMap.get(filterType.toLowerCase());
        }
        return filter;
    }

    protected List<String> getFilterPatterns(String site, String filterType) {
        if ("component".equalsIgnoreCase(filterType)) {
            List<String> toRet = this.servicesConfig.getComponentPatterns(site);
            List<String> levelConfig = this.servicesConfig.getLevelDescriptorPatterns(site);
            if (levelConfig != null) {
                toRet.addAll(levelConfig);
            }
            return toRet;
        }
        if ("asset".equalsIgnoreCase(filterType)) {
            return this.servicesConfig.getAssetPatterns(site);
        }
        if ("renderingTemplate".equalsIgnoreCase(filterType)) {
            return this.servicesConfig.getRenderingTemplatePatterns(site);
        }
        if ("document".equalsIgnoreCase(filterType)) {
            return this.servicesConfig.getDocumentPatterns(site);
        }
        if ("all".equalsIgnoreCase(filterType)) {
            return Arrays.asList(".*");
        }
        if ("page".equalsIgnoreCase(filterType)) {
            return this.servicesConfig.getPagePatterns(site);
        }
        return null;
    }

    @Override
    public boolean accept(String site, String relativePath, String filterType) {
        List<String> patterns;
        if (relativePath != null && (patterns = this.getFilterPatterns(site, filterType)) != null) {
            return ContentUtils.matchesPatterns(relativePath, patterns);
        }
        return false;
    }
}

