/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v2.annotation;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.craftercms.commons.aop.AopUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.RetryingOperationErrorException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.springframework.dao.DeadlockLoserDataAccessException;

@Aspect
public class RetryingOperationAspect {
    private static final Logger logger = LoggerFactory.getLogger(RetryingOperationAspect.class);
    private static final int DEFAULT_MAX_RETRIES = 50;
    private int maxRetries = 50;
    private int maxSleep = 0;

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getMaxSleep() {
        return this.maxSleep;
    }

    public void setMaxSleep(int maxSleep) {
        this.maxSleep = maxSleep;
    }

    @Around(value="@within(org.craftercms.studio.api.v2.annotation.RetryingOperation) || @annotation(org.craftercms.studio.api.v2.annotation.RetryingOperation)")
    public Object doRetryingOperation(ProceedingJoinPoint pjp) throws Throwable {
        Method method = AopUtils.getActualMethod((JoinPoint)pjp);
        int numAttempts = 0;
        while (true) {
            ++numAttempts;
            try {
                if (numAttempts > 1) {
                    logger.debug("Retrying operation attempt " + (numAttempts - 1), new Object[0]);
                }
                return pjp.proceed();
            }
            catch (JGitInternalException | DeadlockLoserDataAccessException ex) {
                logger.debug("Failed to execute " + method.getName() + " after " + numAttempts + " attempts", ex);
                if (numAttempts > this.maxRetries) {
                    throw new RetryingOperationErrorException("Failed to execute " + method.getName() + " after " + numAttempts + " attempts", (Exception)ex);
                }
                long sleep = (long)(Math.random() * (double)this.maxSleep);
                logger.debug("Wait for " + sleep + " before next retry" + method.getName(), new Object[0]);
                Thread.sleep(sleep);
                if (numAttempts < this.maxRetries) continue;
                return null;
            }
            break;
        }
    }
}

