/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v2.annotation;

import java.lang.reflect.Method;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.craftercms.commons.aop.AopUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.RetryingOperationErrorException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.LockFailedException;

@Aspect
public class RetryingRepositoryOperationAspect {
    private static final Logger logger = LoggerFactory.getLogger(RetryingRepositoryOperationAspect.class);
    private static final int DEFAULT_MAX_RETRIES = 50;
    private int maxRetries = 50;
    private int maxSleep = 0;

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getMaxSleep() {
        return this.maxSleep;
    }

    public void setMaxSleep(int maxSleep) {
        this.maxSleep = maxSleep;
    }

    @Around(value="@within(org.craftercms.studio.api.v2.annotation.RetryingRepositoryOperation) || @annotation(org.craftercms.studio.api.v2.annotation.RetryingRepositoryOperation)")
    public Object doRetryingOperation(ProceedingJoinPoint pjp) throws Throwable {
        Method method = AopUtils.getActualMethod((JoinPoint)pjp);
        int numAttempts = 0;
        while (true) {
            ++numAttempts;
            try {
                if (numAttempts > 1) {
                    logger.debug("Retrying repository operation attempt " + (numAttempts - 1), new Object[0]);
                }
                return pjp.proceed();
            }
            catch (JGitInternalException ex) {
                if (Objects.nonNull(ex.getCause()) && ex.getCause() instanceof LockFailedException) {
                    logger.debug("Failed to execute " + method.getName() + " after " + numAttempts + " attempts", new Object[]{ex});
                    if (numAttempts > this.maxRetries) {
                        throw new RetryingOperationErrorException("Failed to execute " + method.getName() + " due to the Git repository being locked after " + numAttempts + " attempts", (Exception)((Object)ex));
                    }
                } else {
                    throw new RetryingOperationErrorException("Failed to execute " + method.getName() + " due to a Git error that does not cause retry attempts", (Exception)((Object)ex));
                }
                long sleep = (long)(Math.random() * (double)this.maxSleep);
                logger.debug("Git operation failed due to the repository being locked. Will wait for " + sleep + " before next retry" + method.getName(), new Object[0]);
                Thread.sleep(sleep);
                if (numAttempts < this.maxRetries) continue;
                return null;
            }
            break;
        }
    }
}

