/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v2.dal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.craftercms.studio.api.v2.dal.UserGroup;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class User
implements UserDetails {
    private static final long serialVersionUID = 968000561389890945L;
    private long id = -1L;
    private ZonedDateTime recordLastUpdated;
    private String username;
    private String password;
    private String firstName;
    private String lastName;
    private boolean externallyManaged;
    private String timezone;
    private String locale;
    private String email;
    private boolean enabled;
    private boolean deleted;
    private List<UserGroup> groups = new ArrayList<UserGroup>();

    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @JsonProperty(value="enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonIgnore
    public boolean isDeleted() {
        return this.deleted;
    }

    @JsonIgnore
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @JsonIgnore
    public int getEnabledAsInt() {
        return this.enabled ? 1 : 0;
    }

    @JsonIgnore
    public void setEnabledAsInt(int enabled) {
        this.enabled = enabled > 0;
    }

    @JsonIgnore
    public int getDeletedAsInt() {
        return this.deleted ? 1 : 0;
    }

    @JsonIgnore
    public void setDeletedAsInt(int deleted) {
        this.deleted = deleted > 0;
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.groups.stream().map(UserGroup::getGroup).collect(Collectors.toList());
    }

    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(long id) {
        this.id = id;
    }

    @JsonIgnore
    public ZonedDateTime getRecordLastUpdated() {
        return this.recordLastUpdated;
    }

    @JsonIgnore
    public void setRecordLastUpdated(ZonedDateTime recordLastUpdated) {
        this.recordLastUpdated = recordLastUpdated;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @JsonProperty(value="externallyManaged")
    public boolean isExternallyManaged() {
        return this.externallyManaged;
    }

    @JsonProperty(value="externallyManaged")
    public void setExternallyManaged(boolean externallyManaged) {
        this.externallyManaged = externallyManaged;
    }

    @JsonIgnore
    public int getExternallyManagedAsInt() {
        return this.externallyManaged ? 1 : 0;
    }

    @JsonIgnore
    public void setExternallyManagedAsInt(int externallyManaged) {
        this.externallyManaged = externallyManaged > 0;
    }

    @JsonIgnore
    public String getTimezone() {
        return this.timezone;
    }

    @JsonIgnore
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @JsonIgnore
    public String getLocale() {
        return this.locale;
    }

    @JsonIgnore
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonIgnore
    public List<UserGroup> getGroups() {
        return this.groups;
    }

    @JsonIgnore
    public void setGroups(List<UserGroup> groups) {
        this.groups = groups;
    }
}

