/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v2.repository;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.to.DeploymentItemTO;
import org.craftercms.studio.api.v2.dal.GitLog;
import org.craftercms.studio.api.v2.dal.PublishingHistoryItem;
import org.craftercms.studio.api.v2.dal.RepoOperation;

public interface ContentRepository {
    public List<String> getSubtreeItems(String var1, String var2);

    public List<RepoOperation> getOperations(String var1, String var2, String var3);

    public List<RepoOperation> getOperationsFromDelta(String var1, String var2, String var3);

    public String getRepoFirstCommitId(String var1);

    public GitLog getGitLog(String var1, String var2);

    public void markGitLogVerifiedProcessed(String var1, String var2);

    public void markGitLogVerifiedProcessedBulk(String var1, List<String> var2);

    public void insertGitLog(String var1, String var2, int var3);

    public void insertGitLog(String var1, String var2, int var3, int var4);

    public List<PublishingHistoryItem> getPublishingHistory(String var1, String var2, String var3, String var4, ZonedDateTime var5, ZonedDateTime var6, int var7);

    public boolean createSiteFromBlueprint(String var1, String var2, String var3, Map<String, String> var4);

    public void publish(String var1, String var2, List<DeploymentItemTO> var3, String var4, String var5, String var6) throws DeploymentException;

    public boolean repositoryExists(String var1);

    public boolean commitIdExists(String var1, String var2);

    public boolean commitIdExists(String var1, GitRepositories var2, String var3);

    public boolean createSiteCloneRemote(String var1, String var2, String var3, String var4, String var5, boolean var6, String var7, String var8, String var9, String var10, String var11, Map<String, String> var12, boolean var13) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, InvalidRemoteUrlException, ServiceLayerException;

    public boolean removeRemote(String var1, String var2);

    public boolean contentExists(String var1, String var2);

    public String getRepoLastCommitId(String var1);

    public String getLastEditCommitId(String var1, String var2);

    public Map<String, String> getChangeSetPathsFromDelta(String var1, String var2, String var3);

    public void markGitLogAudited(String var1, String var2);

    public void updateGitlog(String var1, String var2, int var3) throws SiteNotFoundException;

    public List<GitLog> getUnauditedCommits(String var1, int var2);

    public List<GitLog> getUnprocessedCommits(String var1, long var2);

    public void markGitLogProcessedBeforeMarker(String var1, long var2, int var4);

    public String getPreviousCommitId(String var1, String var2);

    public void upsertGitLogList(String var1, List<String> var2, boolean var3, boolean var4);
}

