/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v2.service.repository.internal;

import java.util.List;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteNotRemovableException;
import org.craftercms.studio.api.v2.dal.DiffConflictedFile;
import org.craftercms.studio.api.v2.dal.RemoteRepository;
import org.craftercms.studio.api.v2.dal.RemoteRepositoryInfo;
import org.craftercms.studio.api.v2.dal.RepositoryStatus;

public interface RepositoryManagementServiceInternal {
    public boolean addRemote(String var1, RemoteRepository var2) throws ServiceLayerException, InvalidRemoteUrlException;

    public List<RemoteRepositoryInfo> listRemotes(String var1, String var2) throws ServiceLayerException, CryptoException;

    public boolean pullFromRemote(String var1, String var2, String var3, String var4) throws InvalidRemoteUrlException, ServiceLayerException, CryptoException;

    public boolean pushToRemote(String var1, String var2, String var3, boolean var4) throws CryptoException, ServiceLayerException, InvalidRemoteUrlException;

    public boolean removeRemote(String var1, String var2) throws CryptoException, RemoteNotRemovableException;

    public RepositoryStatus getRepositoryStatus(String var1) throws CryptoException, ServiceLayerException;

    public boolean resolveConflict(String var1, String var2, String var3) throws CryptoException, ServiceLayerException;

    public DiffConflictedFile getDiffForConflictedFile(String var1, String var2) throws ServiceLayerException, CryptoException;

    public boolean commitResolution(String var1, String var2) throws CryptoException, ServiceLayerException;

    public boolean cancelFailedPull(String var1) throws ServiceLayerException, CryptoException;

    public boolean unlockRepository(String var1, GitRepositories var2) throws CryptoException;
}

