/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v2.service.security;

import javax.servlet.http.HttpSession;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.service.security.AuthenticationChain;
import org.craftercms.studio.api.v2.service.security.AuthenticationProvider;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.SessionTokenUtils;
import org.craftercms.studio.impl.v2.service.security.Authentication;

public abstract class BaseAuthenticationProvider
implements AuthenticationProvider {
    private boolean enabled;

    protected String createToken(User user, AuthenticationChain authenticationChain) {
        StudioConfiguration studioConfiguration = authenticationChain.getStudioConfiguration();
        int timeout = studioConfiguration.getProperty("studio.security.sessionTimeout", Integer.class);
        String token = SessionTokenUtils.createToken(user.getUsername(), timeout);
        return token;
    }

    protected void storeAuthentication(Authentication authentication) {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            httpSession.setAttribute("studio_authentication", (Object)authentication);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

