/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v2.service.security;

import java.util.List;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserExternallyManagedException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.model.AuthenticatedUser;
import org.craftercms.studio.model.Site;

public interface UserService {
    public List<User> getAllUsersForSite(long var1, String var3, int var4, int var5, String var6) throws ServiceLayerException;

    public List<User> getAllUsers(int var1, int var2, String var3) throws ServiceLayerException;

    public int getAllUsersForSiteTotal(long var1, String var3) throws ServiceLayerException;

    public int getAllUsersTotal() throws ServiceLayerException;

    public User createUser(User var1) throws UserAlreadyExistsException, ServiceLayerException, AuthenticationException;

    public void updateUser(User var1) throws ServiceLayerException, UserNotFoundException, AuthenticationException;

    public void deleteUsers(List<Long> var1, List<String> var2) throws ServiceLayerException, AuthenticationException, UserNotFoundException;

    public User getUserByIdOrUsername(long var1, String var3) throws ServiceLayerException, UserNotFoundException;

    public List<User> enableUsers(List<Long> var1, List<String> var2, boolean var3) throws ServiceLayerException, UserNotFoundException, AuthenticationException;

    public List<Site> getUserSites(long var1, String var3) throws ServiceLayerException, UserNotFoundException;

    public List<String> getUserSiteRoles(long var1, String var3, String var4) throws ServiceLayerException, UserNotFoundException;

    public AuthenticatedUser getCurrentUser() throws AuthenticationException, ServiceLayerException;

    public List<Site> getCurrentUserSites() throws AuthenticationException, ServiceLayerException;

    public List<String> getCurrentUserSiteRoles(String var1) throws AuthenticationException, ServiceLayerException;

    public String getCurrentUserSsoLogoutUrl() throws AuthenticationException, ServiceLayerException;

    public boolean forgotPassword(String var1) throws ServiceLayerException, UserNotFoundException, UserExternallyManagedException;

    public User changePassword(String var1, String var2, String var3) throws PasswordDoesNotMatchException, UserExternallyManagedException, ServiceLayerException, AuthenticationException, UserNotFoundException;

    public User setPassword(String var1, String var2) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException;

    public boolean resetPassword(String var1, String var2) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException;

    public boolean validateToken(String var1) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException;
}

