/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v2.utils;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.exception.RepositoryLockedException;
import org.craftercms.studio.api.v2.repository.RetryingRepositoryOperationFacade;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.repository.StrSubstitutorVisitor;
import org.craftercms.studio.impl.v1.repository.git.TreeCopier;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.util.FS;
import org.springframework.core.io.ClassPathResource;

public class GitRepositoryHelper {
    private static final Logger logger = LoggerFactory.getLogger(GitRepositoryHelper.class);
    private static GitRepositoryHelper instance;
    private StudioConfiguration studioConfiguration;
    private TextEncryptor encryptor;
    private SecurityService securityService;
    private UserServiceInternal userServiceInternal;
    private GeneralLockService generalLockService;
    private RetryingRepositoryOperationFacade retryingRepositoryOperationFacade;
    private Map<String, Repository> sandboxes = new HashMap<String, Repository>();
    private Map<String, Repository> published = new HashMap<String, Repository>();
    private Repository globalRepo = null;

    private GitRepositoryHelper() {
    }

    public static GitRepositoryHelper getHelper(StudioConfiguration studioConfiguration, SecurityService securityService, UserServiceInternal userServiceInternal, TextEncryptor textEncryptor, GeneralLockService generalLockService, RetryingRepositoryOperationFacade retryingRepositoryOperationFacade) throws CryptoException {
        if (instance == null) {
            instance = new GitRepositoryHelper();
            GitRepositoryHelper.instance.studioConfiguration = studioConfiguration;
            GitRepositoryHelper.instance.encryptor = textEncryptor;
            GitRepositoryHelper.instance.securityService = securityService;
            GitRepositoryHelper.instance.userServiceInternal = userServiceInternal;
            GitRepositoryHelper.instance.generalLockService = generalLockService;
            GitRepositoryHelper.instance.retryingRepositoryOperationFacade = retryingRepositoryOperationFacade;
        }
        return instance;
    }

    public Repository getRepository(String siteId, GitRepositories gitRepository) {
        return this.getRepository(siteId, gitRepository, null);
    }

    public Repository getRepository(String siteId, GitRepositories gitRepository, String sandboxBranch) {
        Repository repo;
        logger.debug("getRepository invoked with site" + siteId + "Repository Type: " + gitRepository.toString(), new Object[0]);
        switch (gitRepository) {
            case SANDBOX: {
                repo = this.sandboxes.get(siteId);
                if (repo != null) break;
                if (this.buildSiteRepo(siteId)) {
                    repo = this.sandboxes.get(siteId);
                    if (!StringUtils.isNotEmpty((CharSequence)sandboxBranch)) break;
                    this.checkoutSandboxBranch(siteId, repo, sandboxBranch);
                    break;
                }
                logger.warn("Couldn't get the sandbox repository for site: " + siteId, new Object[0]);
                break;
            }
            case PUBLISHED: {
                repo = this.published.get(siteId);
                if (repo != null) break;
                if (this.buildSiteRepo(siteId)) {
                    repo = this.published.get(siteId);
                    break;
                }
                logger.warn("Couldn't get the published repository for site: " + siteId, new Object[0]);
                break;
            }
            case GLOBAL: {
                if (this.globalRepo == null) {
                    Path globalConfigRepoPath = this.buildRepoPath(GitRepositories.GLOBAL).resolve(".git");
                    try {
                        this.globalRepo = this.openRepository(globalConfigRepoPath);
                    }
                    catch (IOException e) {
                        logger.error("Error getting the global repository.", e, new Object[0]);
                    }
                }
                repo = this.globalRepo;
                break;
            }
            default: {
                repo = null;
            }
        }
        if (repo != null) {
            logger.debug("success in getting the repository for site: " + siteId, new Object[0]);
        } else {
            logger.debug("failure in getting the repository for site: " + siteId, new Object[0]);
        }
        return repo;
    }

    public boolean buildSiteRepo(String siteId) {
        boolean toReturn = false;
        Path siteSandboxRepoPath = this.buildRepoPath(GitRepositories.SANDBOX, siteId).resolve(".git");
        Path sitePublishedRepoPath = this.buildRepoPath(GitRepositories.PUBLISHED, siteId).resolve(".git");
        try {
            if (Files.exists(siteSandboxRepoPath, new LinkOption[0])) {
                Repository sandboxRepo = this.openRepository(siteSandboxRepoPath);
                this.sandboxes.put(siteId, sandboxRepo);
                toReturn = true;
            }
        }
        catch (IOException e) {
            logger.error("Failed to create sandbox repo for site: " + siteId + " using path " + siteSandboxRepoPath.toString(), e, new Object[0]);
        }
        try {
            if (toReturn && Files.exists(sitePublishedRepoPath, new LinkOption[0])) {
                Repository publishedRepo = this.openRepository(sitePublishedRepoPath);
                this.published.put(siteId, publishedRepo);
                toReturn = true;
            }
        }
        catch (IOException e) {
            logger.error("Failed to create published repo for site: " + siteId + " using path " + sitePublishedRepoPath.toString(), e, new Object[0]);
        }
        return toReturn;
    }

    public Path buildRepoPath(GitRepositories repoType) {
        return this.buildRepoPath(repoType, "");
    }

    public Path buildRepoPath(GitRepositories repoType, String siteId) {
        Path path;
        switch (repoType) {
            case SANDBOX: {
                path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), siteId, this.studioConfiguration.getProperty("studio.repo.siteSandboxPath"));
                break;
            }
            case PUBLISHED: {
                path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), siteId, this.studioConfiguration.getProperty("studio.repo.sitePublishedPath"));
                break;
            }
            case GLOBAL: {
                path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.globalRepoPath"));
                break;
            }
            default: {
                path = null;
            }
        }
        return path;
    }

    public Repository openRepository(Path repositoryPath) throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(repositoryPath.toFile())).readEnvironment()).findGitDir()).build();
        return repository;
    }

    public boolean isRemoteValid(Git git, String remote, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws CryptoException, IOException, ServiceLayerException, GitAPIException {
        LsRemoteCommand lsRemoteCommand = git.lsRemote();
        lsRemoteCommand.setRemote(remote);
        Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
        lsRemoteCommand = this.setAuthenticationForCommand(lsRemoteCommand, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey, tempKey, false);
        lsRemoteCommand.call();
        Files.deleteIfExists(tempKey);
        return true;
    }

    public SshSessionFactory getSshSessionFactory(String privateKey, final Path tempKey) {
        try {
            Files.write(tempKey, privateKey.getBytes(), new OpenOption[0]);
            JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host hc, Session session) {
                    Properties config = new Properties();
                    config.put("StrictHostKeyChecking", "no");
                    session.setConfig(config);
                }

                protected JSch createDefaultJSch(FS fs) throws JSchException {
                    JSch defaultJSch = new JSch();
                    defaultJSch.addIdentity(tempKey.toAbsolutePath().toString());
                    return defaultJSch;
                }
            };
            return sshSessionFactory;
        }
        catch (IOException e) {
            logger.error("Failed to create private key for SSH connection.", e, new Object[0]);
            return null;
        }
    }

    public <T extends TransportCommand> T setAuthenticationForCommand(T gitCommand, String authenticationType, String username, String password, String token, String privateKey, final Path tempKey, boolean decrypt) throws CryptoException, ServiceLayerException {
        String passwordValue = password;
        String tokenValue = token;
        String privateKeyValue = privateKey;
        if (decrypt) {
            if (!StringUtils.isEmpty((CharSequence)password)) {
                passwordValue = this.encryptor.decrypt(password);
            }
            if (!StringUtils.isEmpty((CharSequence)token)) {
                tokenValue = this.encryptor.decrypt(token);
            }
            if (!StringUtils.isEmpty((CharSequence)privateKey)) {
                privateKeyValue = this.encryptor.decrypt(privateKey);
            }
        }
        final String pk = privateKeyValue;
        switch (authenticationType) {
            case "none": {
                logger.debug("No authentication", new Object[0]);
                break;
            }
            case "basic": {
                logger.debug("Basic authentication", new Object[0]);
                UsernamePasswordCredentialsProvider credentialsProviderUP = new UsernamePasswordCredentialsProvider(username, passwordValue);
                gitCommand.setCredentialsProvider((CredentialsProvider)credentialsProviderUP);
                break;
            }
            case "token": {
                logger.debug("Token based authentication", new Object[0]);
                UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(tokenValue, "");
                gitCommand.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                break;
            }
            case "key": {
                logger.debug("Private key authentication", new Object[0]);
                tempKey.toFile().deleteOnExit();
                gitCommand.setTransportConfigCallback(new TransportConfigCallback(){

                    public void configure(Transport transport) {
                        SshTransport sshTransport = (SshTransport)transport;
                        sshTransport.setSshSessionFactory(GitRepositoryHelper.this.getSshSessionFactory(pk, tempKey));
                    }
                });
                break;
            }
            default: {
                throw new ServiceLayerException("Unsupported authentication type " + authenticationType);
            }
        }
        return gitCommand;
    }

    public String getGitPath(String path) {
        Path gitPath = Paths.get(path, new String[0]);
        gitPath = gitPath.normalize();
        try {
            gitPath = Paths.get("/", new String[0]).relativize(gitPath);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Path: " + path + " is already relative path.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)gitPath.toString())) {
            return ".";
        }
        String toRet = gitPath.toString();
        toRet = FilenameUtils.separatorsToUnix((String)toRet);
        return toRet;
    }

    public PersonIdent getAuthorIdent(User user) throws ServiceLayerException, UserNotFoundException {
        PersonIdent currentUserIdent = new PersonIdent(user.getFirstName() + " " + user.getLastName(), user.getEmail());
        return currentUserIdent;
    }

    public RevTree getTreeForCommit(Repository repository, String commitId) throws IOException {
        ObjectId commitObjectId = repository.resolve(commitId);
        try (RevWalk revWalk = new RevWalk(repository);){
            RevTree tree;
            RevCommit commit = revWalk.parseCommit((AnyObjectId)commitObjectId);
            RevTree revTree = tree = commit.getTree();
            return revTree;
        }
    }

    public RevTree getTreeForLastCommit(Repository repository) throws IOException {
        ObjectId lastCommitId = repository.resolve("HEAD");
        try (RevWalk revWalk = new RevWalk(repository);){
            RevTree tree;
            RevCommit commit = revWalk.parseCommit((AnyObjectId)lastCommitId);
            RevTree revTree = tree = commit.getTree();
            return revTree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFilesInCommit(Repository repository, RevCommit commit) {
        ArrayList<String> files;
        block33: {
            files = new ArrayList<String>();
            RevWalk rw = new RevWalk(repository);
            try (Git git = new Git(repository);){
                if (commit.getParentCount() <= 0) break block33;
                RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                ObjectId commitId = commit.getId();
                ObjectId parentCommitId = parent.getId();
                RevTree parentTree = this.getTreeForCommit(repository, parentCommitId.getName());
                RevTree commitTree = this.getTreeForCommit(repository, commitId.getName());
                if (parentTree == null || commitTree == null) break block33;
                try (ObjectReader reader = repository.newObjectReader();){
                    CanonicalTreeParser prevCommitTreeParser = new CanonicalTreeParser();
                    CanonicalTreeParser nextCommitTreeParser = new CanonicalTreeParser();
                    prevCommitTreeParser.reset(reader, (AnyObjectId)parentTree.getId());
                    nextCommitTreeParser.reset(reader, (AnyObjectId)commitTree.getId());
                    List diffEntries = git.diff().setOldTree((AbstractTreeIterator)prevCommitTreeParser).setNewTree((AbstractTreeIterator)nextCommitTreeParser).call();
                    for (DiffEntry diffEntry : diffEntries) {
                        if (diffEntry.getChangeType() == DiffEntry.ChangeType.DELETE) {
                            files.add("/" + diffEntry.getOldPath());
                            continue;
                        }
                        files.add("/" + diffEntry.getNewPath());
                    }
                }
                catch (IOException | GitAPIException e) {
                    logger.error("Error while getting list of files in commit " + commit.getId().getName(), new Object[0]);
                }
            }
            catch (IOException e) {
                logger.error("Error while getting list of files in commit " + commit.getId().getName(), new Object[0]);
            }
            finally {
                rw.dispose();
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSandboxRepository(String site, String sandboxBranch) {
        boolean toReturn;
        Repository sandboxRepo = null;
        Path siteSandboxPath = this.buildRepoPath(GitRepositories.SANDBOX, site);
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            sandboxRepo = this.createGitRepository(siteSandboxPath);
            boolean bl = toReturn = sandboxRepo != null;
            if (toReturn && (toReturn = this.checkoutSandboxBranch(site, sandboxRepo, sandboxBranch))) {
                this.sandboxes.put(site, sandboxRepo);
            }
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createPublishedRepository(String siteId, String sandboxBranch) {
        boolean toRet = false;
        Path siteSandboxPath = this.buildRepoPath(GitRepositories.SANDBOX, siteId);
        Path sitePublishedPath = this.buildRepoPath(GitRepositories.PUBLISHED, siteId);
        String gitLockKey = "{site}_PUBLISHED_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        this.generalLockService.lock(gitLockKey);
        try (Git publishedGit = Git.cloneRepository().setURI(sitePublishedPath.relativize(siteSandboxPath).toString()).setDirectory(sitePublishedPath.normalize().toAbsolutePath().toFile()).call();){
            Repository publishedRepo = publishedGit.getRepository();
            publishedRepo = this.optimizeRepository(publishedRepo);
            this.checkoutSandboxBranch(siteId, publishedRepo, sandboxBranch);
            publishedRepo.close();
            publishedGit.close();
            toRet = true;
        }
        catch (IOException | GitAPIException e) {
            logger.error("Error adding origin (sandbox) to published repository", (Exception)e, new Object[0]);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return toRet;
    }

    public Repository createGitRepository(Path path) {
        Repository toReturn;
        path = Paths.get(path.toAbsolutePath().toString(), ".git");
        try {
            toReturn = FileRepositoryBuilder.create((File)path.toFile());
            toReturn.create();
            toReturn = this.optimizeRepository(toReturn);
            try (Git git = new Git(toReturn);){
                git.commit().setAllowEmpty(true).setMessage(this.getCommitMessage("studio.repo.createRepository.commitMessage")).call();
            }
            catch (GitAPIException e) {
                logger.error("Error while creating repository for site with path" + path.toString(), (Exception)((Object)e), new Object[0]);
                toReturn = null;
            }
        }
        catch (IOException e) {
            logger.error("Error while creating repository for site with path" + path.toString(), e, new Object[0]);
            toReturn = null;
        }
        return toReturn;
    }

    private Repository optimizeRepository(Repository repo) throws IOException {
        StoredConfig config = repo.getConfig();
        config.setInt("core", null, "compression", 0);
        config.setString("core", null, "bigFileThreshold", "20m");
        config.setBoolean("core", null, "fileMode", false);
        config.save();
        return repo;
    }

    public String getCommitMessage(String commitMessageKey) {
        String prologue = this.studioConfiguration.getProperty("studio.repo.commitMessagePrologue");
        String postscript = this.studioConfiguration.getProperty("studio.repo.commitMessagePostscript");
        String message = this.studioConfiguration.getProperty(commitMessageKey);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)prologue)) {
            sb.append(prologue).append("\n\n");
        }
        sb.append(message);
        if (StringUtils.isNotEmpty((CharSequence)postscript)) {
            sb.append("\n\n").append(postscript);
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkoutSandboxBranch(String site, Repository sandboxRepo, String sandboxBranch) {
        String sandboxBranchName = sandboxBranch;
        if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
            sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
        }
        try (Git git = new Git(sandboxRepo);){
            if (!StringUtils.equals((CharSequence)sandboxRepo.getBranch(), (CharSequence)sandboxBranchName)) {
                List branchList = git.branchList().call();
                boolean createBranch = true;
                for (Ref branch : branchList) {
                    if (!StringUtils.equals((CharSequence)branch.getName(), (CharSequence)sandboxBranchName) && !StringUtils.equals((CharSequence)branch.getName(), (CharSequence)("refs/heads/" + sandboxBranchName))) continue;
                    createBranch = false;
                    break;
                }
                if (sandboxRepo.isBare() || sandboxRepo.resolve("HEAD") == null) {
                    git.commit().setAllowEmpty(true).setMessage(this.getCommitMessage("studio.repo.createSandboxBranch.commitMessage").replaceAll("\\$\\{sandbox\\}", sandboxBranchName)).call();
                }
                git.checkout().setCreateBranch(createBranch).setName(sandboxBranchName).setForce(false).call();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | GitAPIException e) {
            logger.error("Error checking out sandbox branch " + sandboxBranchName + " for site " + site, (Exception)e, new Object[0]);
            return false;
        }
    }

    public boolean copyContentFromBlueprint(String blueprintLocation, String site) {
        boolean toReturn = true;
        Path siteRepoPath = this.buildRepoPath(GitRepositories.SANDBOX, site);
        Path blueprintPath = Paths.get(blueprintLocation, new String[0]);
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        TreeCopier tc = new TreeCopier(blueprintPath, siteRepoPath);
        try {
            Files.walkFileTree(blueprintPath, opts, Integer.MAX_VALUE, tc);
        }
        catch (IOException err) {
            logger.error("Error copping files from blueprint", err, new Object[0]);
            toReturn = false;
        }
        return toReturn;
    }

    public boolean updateSiteNameConfigVar(String site) {
        boolean toReturn = true;
        String siteConfigFolder = "/config/studio";
        if (!this.replaceSiteNameVariable(site, Paths.get(this.buildRepoPath(GitRepositories.SANDBOX, site).toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.configuration.site.configBasePath"), this.studioConfiguration.getProperty("studio.configuration.site.generalConfigFileName")))) {
            toReturn = false;
        } else if (!this.replaceSiteNameVariable(site, Paths.get(this.buildRepoPath(GitRepositories.SANDBOX, site).toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.configuration.site.configBasePath"), this.studioConfiguration.getProperty("studio.configuration.site.permissionMappingsFileName")))) {
            toReturn = false;
        } else if (!this.replaceSiteNameVariable(site, Paths.get(this.buildRepoPath(GitRepositories.SANDBOX, site).toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.configuration.site.configBasePath"), this.studioConfiguration.getProperty("studio.configuration.site.roleMappingsFileName")))) {
            toReturn = false;
        }
        return toReturn;
    }

    protected boolean replaceSiteNameVariable(String site, Path path) {
        boolean toReturn = false;
        Charset charset = StandardCharsets.UTF_8;
        String content = null;
        try {
            content = new String(Files.readAllBytes(path), charset);
            content = content.replaceAll("\\{siteName\\}", site);
            Files.write(path, content.getBytes(charset), new OpenOption[0]);
            toReturn = true;
        }
        catch (IOException e) {
            logger.error("Error replacing sitename variable inside configuration file " + path.toString() + " for site " + site, new Object[0]);
            toReturn = false;
        }
        return toReturn;
    }

    public boolean replaceParameters(String siteId, Map<String, String> parameters) {
        if (MapUtils.isEmpty(parameters)) {
            logger.debug("Skipping parameter replacement for site {0}", siteId);
            return true;
        }
        String configRootPath = FilenameUtils.getPath((String)this.studioConfiguration.getProperty("studio.configuration.site.configBasePath"));
        Path siteSandboxPath = this.buildRepoPath(GitRepositories.SANDBOX, siteId);
        Path configFolder = siteSandboxPath.resolve(configRootPath);
        try {
            Files.walkFileTree(configFolder, new StrSubstitutorVisitor(parameters));
            return true;
        }
        catch (IOException e) {
            logger.error("Error looking for configuration files for site {0}", e, siteId);
            return false;
        }
    }

    public boolean addGitIgnoreFile(String siteId) {
        block29: {
            String defaultFileLocation = this.studioConfiguration.getProperty("studio.repo.defaultIgnoreFile");
            ClassPathResource defaultFile = new ClassPathResource(defaultFileLocation);
            if (defaultFile.exists()) {
                logger.debug("Adding ignore file for site {0}", siteId);
                Path siteSandboxPath = this.buildRepoPath(GitRepositories.SANDBOX, siteId);
                Path ignoreFile = siteSandboxPath.resolve(".gitignore");
                if (!Files.exists(ignoreFile, new LinkOption[0])) {
                    try (OutputStream out = Files.newOutputStream(ignoreFile, StandardOpenOption.CREATE);
                         InputStream in = defaultFile.getInputStream();){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        break block29;
                    }
                    catch (IOException e) {
                        logger.error("Error writing ignore file for site {0}", e, siteId);
                        return false;
                    }
                }
                logger.debug("Repository already contains an ignore file for site {0}", siteId);
            } else {
                logger.warn("Could not find the default ignore file at {0}", defaultFileLocation);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performInitialCommit(String site, String message, String sandboxBranch) {
        boolean toReturn = true;
        Repository repo = this.getRepository(site, GitRepositories.SANDBOX, sandboxBranch);
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try (Git git = new Git(repo);){
            Status status = git.status().call();
            if (status.hasUncommittedChanges() || !status.isClean()) {
                DirCache dirCache = git.add().addFilepattern(".").call();
                CommitCommand commitCommand = git.commit().setMessage(message);
                String username = this.securityService.getCurrentUser();
                User user = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
                if (Objects.nonNull(user)) {
                    commitCommand = commitCommand.setAuthor(this.getAuthorIdent(user));
                }
                RevCommit revCommit = commitCommand.call();
            }
            this.checkoutSandboxBranch(site, repo, sandboxBranch);
            git.close();
        }
        catch (ServiceLayerException | UserNotFoundException | GitAPIException err) {
            logger.error("error creating initial commit for site:  " + site, (Exception)err, new Object[0]);
            toReturn = false;
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSiteCloneRemoteGitRepo(String siteId, String sandboxBranch, String remoteName, String remoteUrl, String remoteBranch, boolean singleBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, final String remotePrivateKey, boolean createAsOrphan) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, ServiceLayerException {
        boolean toRet = true;
        Path siteSandboxPath = this.buildRepoPath(GitRepositories.SANDBOX, siteId);
        File localPath = siteSandboxPath.toFile();
        localPath.delete();
        logger.debug("Add user credentials if provided", new Object[0]);
        logger.debug("Cloning from " + remoteUrl + " to " + localPath, new Object[0]);
        CloneCommand cloneCommand = Git.cloneRepository();
        Git cloneResult = null;
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        this.generalLockService.lock(gitLockKey);
        try {
            final Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
            switch (authenticationType) {
                case "none": {
                    logger.debug("No authentication", new Object[0]);
                    break;
                }
                case "basic": {
                    logger.debug("Basic authentication", new Object[0]);
                    cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteUsername, remotePassword));
                    break;
                }
                case "token": {
                    logger.debug("Token based authentication", new Object[0]);
                    cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteToken, ""));
                    break;
                }
                case "key": {
                    logger.debug("Private key authentication", new Object[0]);
                    tempKey.toFile().deleteOnExit();
                    cloneCommand.setTransportConfigCallback(new TransportConfigCallback(){

                        public void configure(Transport transport) {
                            SshTransport sshTransport = (SshTransport)transport;
                            sshTransport.setSshSessionFactory(GitRepositoryHelper.this.getSshSessionFactory(remotePrivateKey, tempKey));
                        }
                    });
                    break;
                }
                default: {
                    throw new ServiceLayerException("Unsupported authentication type " + authenticationType);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)remoteBranch)) {
                cloneCommand.setBranch(remoteBranch);
            }
            cloneResult = cloneCommand.setURI(remoteUrl).setDirectory(localPath).setRemote(remoteName).setCloneAllBranches(!singleBranch).call();
            Files.deleteIfExists(tempKey);
            Repository sandboxRepo = this.checkIfCloneWasOk(cloneResult, remoteName, remoteUrl);
            sandboxRepo = this.optimizeRepository(sandboxRepo);
            if (createAsOrphan) {
                this.makeRepoOrphan(sandboxRepo, siteId);
            }
            this.sandboxes.put(siteId, sandboxRepo);
        }
        catch (InvalidRemoteException e) {
            logger.error("Invalid remote repository: " + remoteName + " (" + remoteUrl + ")", (Exception)((Object)e), new Object[0]);
            throw new InvalidRemoteRepositoryException("Invalid remote repository: " + remoteName + " (" + remoteUrl + ")");
        }
        catch (TransportException e) {
            if (StringUtils.endsWithIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"not authorized")) {
                logger.error("Bad credentials or read only repository: " + remoteName + " (" + remoteUrl + ")", (Exception)((Object)e), new Object[0]);
                throw new InvalidRemoteRepositoryCredentialsException("Bad credentials or read only repository: " + remoteName + " (" + remoteUrl + ") for username " + remoteUsername, e);
            }
            logger.error("Remote repository not found: " + remoteName + " (" + remoteUrl + ")", (Exception)((Object)e), new Object[0]);
            throw new RemoteRepositoryNotFoundException("Remote repository not found: " + remoteName + " (" + remoteUrl + ")");
        }
        catch (IOException | UserNotFoundException | GitAPIException e) {
            logger.error("Error while creating repository for site with path" + siteSandboxPath.toString(), (Exception)e, new Object[0]);
            toRet = false;
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
            if (cloneResult != null) {
                cloneResult.close();
            }
        }
        return toRet;
    }

    private Repository checkIfCloneWasOk(Git cloneResult, String remoteName, String remoteUrl) throws InvalidRemoteRepositoryException {
        if (cloneResult == null) {
            String msg = "Remote Clone Error:: " + remoteName + " (" + remoteUrl + ")  cloneResult object null";
            logger.error(msg, new Object[0]);
            throw new InvalidRemoteRepositoryException(msg);
        }
        Repository repository = cloneResult.getRepository();
        if (repository == null) {
            String msg = "Remote Clone Error:: " + remoteName + " (" + remoteUrl + ")  sandboxRepo object null";
            logger.error(msg, new Object[0]);
            throw new InvalidRemoteRepositoryException(msg);
        }
        File repoDir = repository.getDirectory();
        if (!(repoDir.exists() && repoDir.isDirectory() && repoDir.canRead() && repoDir.canWrite())) {
            String msg = "Remote Clone Error::  " + repository.getDirectory() + " doesn't exist, is not a dir or user don't have RW permissions";
            logger.error(msg, new Object[0]);
            throw new InvalidRemoteRepositoryException(msg);
        }
        return repository;
    }

    private void makeRepoOrphan(Repository repository, String site) throws IOException, GitAPIException, ServiceLayerException, UserNotFoundException {
        logger.debug("Make repository orphan fir site " + site, new Object[0]);
        String sandboxBranchName = repository.getBranch();
        if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
            sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
        }
        String sandboxBranchOrphanName = sandboxBranchName + "_orphan";
        logger.debug("Shallow clone is not implemented in JGit. Instead we are creating new orphan branch after cloning and renaming it to sandbox branch to replace fully cloned branch", new Object[0]);
        try (Git git = new Git(repository);){
            logger.debug("Create temporary orphan branch " + sandboxBranchOrphanName, new Object[0]);
            git.checkout().setName(sandboxBranchOrphanName).setStartPoint(sandboxBranchName).setOrphan(true).call();
            logger.debug("Soft reset to commit empty repo", new Object[0]);
            git.reset().call();
            logger.debug("Commit empty repo, because we need to have HEAD to delete old and rename new branch", new Object[0]);
            CommitCommand commitCommand = git.commit().setMessage(this.getCommitMessage("studio.repo.createAsOrphan.commitMessage"));
            String username = this.securityService.getCurrentUser();
            User user = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
            if (Objects.nonNull(user)) {
                commitCommand = commitCommand.setAuthor(this.getAuthorIdent(user));
            }
            commitCommand.call();
            logger.debug("Delete cloned branch " + sandboxBranchName, new Object[0]);
            git.branchDelete().setBranchNames(new String[]{sandboxBranchName}).setForce(true).call();
            logger.debug("Rename temporary orphan branch to sandbox branch", new Object[0]);
            git.branchRename().setNewName(sandboxBranchName).setOldName(sandboxBranchOrphanName).call();
        }
    }

    public void removeSandbox(String siteId) {
        this.sandboxes.remove(siteId);
    }

    public boolean buildGlobalRepo() throws IOException {
        boolean toReturn = false;
        Path siteRepoPath = this.buildRepoPath(GitRepositories.GLOBAL).resolve(".git");
        if (Files.exists(siteRepoPath, new LinkOption[0])) {
            this.globalRepo = this.openRepository(siteRepoPath);
            toReturn = true;
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createGlobalRepo() {
        boolean toReturn = false;
        Path globalConfigRepoPath = this.buildRepoPath(GitRepositories.GLOBAL).resolve(".git");
        String gitLockKey = "GLOBAL_REPOSITORY_GIT_LOCK";
        this.generalLockService.lock(gitLockKey);
        try {
            if (!Files.exists(globalConfigRepoPath, new LinkOption[0])) {
                Path globalConfigPath = globalConfigRepoPath.getParent();
                try {
                    Files.deleteIfExists(globalConfigPath);
                    logger.info("Bootstrapping repository...", new Object[0]);
                    Files.createDirectories(globalConfigPath, new FileAttribute[0]);
                    this.globalRepo = this.createGitRepository(globalConfigPath);
                    toReturn = true;
                }
                catch (IOException e) {
                    logger.error("Bootstrapping repository failed", e, new Object[0]);
                }
            } else {
                logger.info("Detected existing global repository, will not create new one.", new Object[0]);
                toReturn = false;
            }
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSiteGitRepo(String site) {
        boolean toReturn;
        Path siteSandboxPath = this.buildRepoPath(GitRepositories.SANDBOX, site);
        Path sitePath = siteSandboxPath.getParent();
        File siteFolder = sitePath.toFile();
        String gitLockKeySandbox = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        String gitLockKeyPublished = "{site}_PUBLISHED_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKeySandbox);
        this.generalLockService.lock(gitLockKeyPublished);
        try {
            Repository pubRepo;
            Repository sboxRepo = this.sandboxes.get(site);
            if (sboxRepo != null) {
                sboxRepo.close();
                this.sandboxes.remove(site);
                RepositoryCache.close((Repository)sboxRepo);
                sboxRepo = null;
            }
            if ((pubRepo = this.published.get(site)) != null) {
                pubRepo.close();
                this.published.remove(site);
                RepositoryCache.close((Repository)pubRepo);
                pubRepo = null;
            }
            FileUtils.deleteDirectory((File)siteFolder);
            toReturn = true;
            logger.debug("Deleted site: " + site + " at path: " + sitePath, new Object[0]);
        }
        catch (IOException e) {
            logger.error("Failed to delete site: " + site + " at path: " + sitePath + " exception " + e.toString(), new Object[0]);
            toReturn = false;
        }
        finally {
            this.generalLockService.unlock(gitLockKeyPublished);
            this.generalLockService.unlock(gitLockKeySandbox);
        }
        return toReturn;
    }

    public boolean writeFile(Repository repo, String site, String path, InputStream content) {
        boolean result;
        block36: {
            result = true;
            try {
                File file = new File(repo.getDirectory().getParent(), path);
                File folder = file.getParentFile();
                if (folder != null && !folder.exists()) {
                    folder.mkdirs();
                }
                if (!file.exists()) {
                    try {
                        if (!file.createNewFile()) {
                            logger.error("error creating file: site: " + site + " path: " + path, new Object[0]);
                            result = false;
                        }
                    }
                    catch (IOException e) {
                        logger.error("error creating file: site: " + site + " path: " + path, e, new Object[0]);
                        result = false;
                    }
                }
                if (!result) break block36;
                try (FileChannel outChannel = new FileOutputStream(file.getPath()).getChannel();){
                    long count;
                    logger.debug("created the file output channel", new Object[0]);
                    ReadableByteChannel inChannel = Channels.newChannel(content);
                    logger.debug("created the file input channel", new Object[0]);
                    long amount = 0x100000L;
                    long offset = 0L;
                    while ((count = outChannel.transferFrom(inChannel, offset, amount)) > 0L) {
                        logger.debug("writing the bits: offset = " + offset + " count: " + count, new Object[0]);
                        offset += count;
                    }
                }
                try {
                    var9_13 = null;
                    try (Git git = new Git(repo);){
                        AddCommand addCommand = git.add().addFilepattern(this.getGitPath(path));
                        this.retryingRepositoryOperationFacade.call(addCommand);
                        git.close();
                        result = true;
                    }
                    catch (Throwable throwable) {
                        var9_13 = throwable;
                        throw throwable;
                    }
                }
                catch (JGitInternalException internalException) {
                    if (internalException.getCause() instanceof LockFailedException) {
                        throw new RepositoryLockedException("Writing file " + path + " for site " + site + " failed because repository was locked.");
                    }
                }
                catch (GitAPIException e) {
                    logger.error("error adding file to git: site: " + site + " path: " + path, (Exception)((Object)e), new Object[0]);
                    result = false;
                }
            }
            catch (IOException e) {
                logger.error("error writing file: site: " + site + " path: " + path, e, new Object[0]);
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String commitFile(Repository repo, String site, String path, String comment, PersonIdent user) {
        String commitId = null;
        String gitPath = this.getGitPath(path);
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try (Git git = new Git(repo);){
            StatusCommand statusCommand = git.status().addPath(gitPath);
            Status status = (Status)this.retryingRepositoryOperationFacade.call(statusCommand);
            if (status.hasUncommittedChanges() || !status.isClean()) {
                CommitCommand commitCommand = git.commit().setOnly(gitPath).setAuthor(user).setCommitter(user).setMessage(comment);
                RevCommit commit = (RevCommit)this.retryingRepositoryOperationFacade.call(commitCommand);
                commitId = commit.getName();
            }
        }
        catch (GitAPIException e) {
            logger.error("error adding and committing file to git: site: " + site + " path: " + path, (Exception)((Object)e), new Object[0]);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return commitId;
    }

    public PersonIdent getCurrentUserIdent() throws ServiceLayerException, UserNotFoundException {
        String userName = this.securityService.getCurrentUser();
        return this.getAuthorIdent(userName);
    }

    public PersonIdent getAuthorIdent(String author) throws ServiceLayerException, UserNotFoundException {
        User user = this.userServiceInternal.getUserByIdOrUsername(-1L, author);
        PersonIdent currentUserIdent = new PersonIdent(user.getFirstName() + " " + user.getLastName(), user.getEmail());
        return currentUserIdent;
    }
}

