/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.api.v2.utils;

import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.service.objectstate.State;

public final class SqlStatementGeneratorUtils {
    public static final String ITEM_STATE_UPSERT = "INSERT INTO item_state (object_id, site, path, state, system_processing) VALUES ('#{objectId}', '#{site}', '#{path}', '#{state}', 0) ON DUPLICATE KEY UPDATE path = '#{path}', state = '#{state}', system_processing = 0 ;";
    public static final String ITEM_STATE_MOVE = "UPDATE item_state SET path = '#{newPath}'  WHERE site = '#{site}' AND path = '#{oldPath}' ;";
    public static final String ITEM_STATE_TRANSITION = "Update item_state SET state = CASE WHEN state = 'NEW_UNPUBLISHED_LOCKED' THEN 'NEW_UNPUBLISHED_UNLOCKED' WHEN state = 'NEW_UNPUBLISHED_UNLOCKED' THEN 'NEW_UNPUBLISHED_UNLOCKED' WHEN state = 'NEW_SUBMITTED_WITH_WF_SCHEDULED' THEN 'NEW_UNPUBLISHED_UNLOCKED' WHEN state = 'NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED' THEN 'NEW_UNPUBLISHED_UNLOCKED' WHEN state = 'NEW_SUBMITTED_WITH_WF_UNSCHEDULED' THEN 'NEW_UNPUBLISHED_UNLOCKED' WHEN state = 'NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED' THEN 'NEW_UNPUBLISHED_UNLOCKED' WHEN state = 'NEW_SUBMITTED_NO_WF_SCHEDULED' THEN 'NEW_UNPUBLISHED_UNLOCKED' WHEN state = 'NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED' THEN 'NEW_UNPUBLISHED_UNLOCKED' WHEN state = 'NEW_SUBMITTED_NO_WF_UNSCHEDULED' THEN 'NEW_UNPUBLISHED_UNLOCKED' WHEN state = 'NEW_PUBLISHING_FAILED' THEN 'NEW_UNPUBLISHED_UNLOCKED' WHEN state = 'NEW_DELETED' THEN state WHEN state = 'EXISTING_UNEDITED_LOCKED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_UNEDITED_UNLOCKED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_EDITED_LOCKED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_EDITED_UNLOCKED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_SUBMITTED_WITH_WF_SCHEDULED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_SUBMITTED_NO_WF_SCHEDULED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_SUBMITTED_NO_WF_SCHEDULED_LOCKED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_SUBMITTED_NO_WF_UNSCHEDULED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_PUBLISHING_FAILED' THEN 'EXISTING_EDITED_UNLOCKED' WHEN state = 'EXISTING_DELETED' THEN state ELSE state END WHERE site = '#{site}' AND path = '#{path}' ; ";
    public static final String ITEM_STATE_DELETE = "DELETE FROM item_state WHERE site = '#{site}' AND path = BINARY '#{path}' ;";
    public static final String ITEM_METADATA_UPSERT = "INSERT INTO item_metadata (site, path, modifier, modified, creator, commit_id) VALUES ('#{site}', '#{path}', '#{modifier}', '#{modified}', '#{creator}', '#{commitId}') ON DUPLICATE KEY UPDATE path = '#{path}', modifier = '#{modifier}', creator = '#{creator}', commit_id = '#{commitId}' ;";
    public static final String ITEM_METADATA_UPDATE = "UPDATE item_metadata SET path = '#{path}', modifier = '#{modifier}', creator = '#{creator}', commit_id = '#{commitId}' WHERE  site = '#{site}' AND path = '#{path}' ;";
    public static final String ITEM_METADATA_MOVE = "UPDATE item_metadata SET path = '#{newPath}' WHERE site = '#{site}' AND path = ''#{oldPath}' ;";
    public static final String ITEM_METADATA_DELETE = "DELETE FROM item_metadata WHERE site = '#{site}' AND path = BINARY '#{path}' ;";
    public static final String DEPENDENCIES_INSERT = "INSERT INTO dependency (site, source_path, target_path, type) VALUES ('#{site}', '#{sourcePath}', '#{targetPath}', '#{type}') ;";
    public static final String DEPENDENCIES_DELETE_SOURCE = "DELETE FROM dependency WHERE source_path = '#{path}' AND site = '#{site}' ;";
    public static final String DEPENDENCIES_DELETE = "DELETE FROM dependency WHERE site = '#{site}' AND (source_path = '#{path}' OR target_path = '#{path}') ;";

    public static String upsertItemStateRow(String site, String path) {
        String sql = StringUtils.replace((String)ITEM_STATE_UPSERT, (String)"#{objectId}", (String)UUID.randomUUID().toString());
        sql = StringUtils.replace((String)sql, (String)"#{site}", (String)StringUtils.replace((String)site, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{path}", (String)StringUtils.replace((String)path, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{state}", (String)State.NEW_UNPUBLISHED_UNLOCKED.name());
        return sql;
    }

    public static String moveItemStateRow(String site, String oldPath, String newPath) {
        String sql = StringUtils.replace((String)ITEM_STATE_MOVE, (String)"#{site}", (String)StringUtils.replace((String)site, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{oldPath}", (String)StringUtils.replace((String)oldPath, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{newPath}", (String)StringUtils.replace((String)newPath, (String)"'", (String)"''"));
        return sql;
    }

    public static String transitionSaveItemStateRow(String site, String path) {
        String sql = StringUtils.replace((String)ITEM_STATE_TRANSITION, (String)"#{site}", (String)StringUtils.replace((String)site, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{path}", (String)StringUtils.replace((String)path, (String)"'", (String)"''"));
        return sql;
    }

    public static String deleteItemStateRow(String site, String path) {
        String sql = StringUtils.replace((String)ITEM_STATE_DELETE, (String)"#{site}", (String)StringUtils.replace((String)site, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{path}", (String)StringUtils.replace((String)path, (String)"'", (String)"''"));
        return sql;
    }

    public static String upsertItemMetadataRow(String siteId, String path, String creator, ZonedDateTime dateTime, String commitId) {
        Timestamp sqlTs = new Timestamp(dateTime.toInstant().toEpochMilli());
        String sql = StringUtils.replace((String)ITEM_METADATA_UPSERT, (String)"#{site}", (String)StringUtils.replace((String)siteId, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{path}", (String)StringUtils.replace((String)path, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{modifier}", (String)StringUtils.replace((String)creator, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{modified}", (String)sqlTs.toString());
        sql = StringUtils.replace((String)sql, (String)"#{creator}", (String)StringUtils.replace((String)creator, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{commitId}", (String)StringUtils.replace((String)commitId, (String)"'", (String)"''"));
        return sql;
    }

    public static String updateItemMetadataRow(String siteId, String path, String creator, ZonedDateTime dateTime, String commitId) {
        Timestamp sqlTs = new Timestamp(dateTime.toInstant().toEpochMilli());
        String sql = StringUtils.replace((String)ITEM_METADATA_UPDATE, (String)"#{site}", (String)StringUtils.replace((String)siteId, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{path}", (String)StringUtils.replace((String)path, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{modifier}", (String)StringUtils.replace((String)creator, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{modified}", (String)sqlTs.toString());
        sql = StringUtils.replace((String)sql, (String)"#{creator}", (String)StringUtils.replace((String)creator, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{commitId}", (String)StringUtils.replace((String)commitId, (String)"'", (String)"''"));
        return sql;
    }

    public static String moveItemMetadataRow(String site, String oldPath, String newPath) {
        String sql = StringUtils.replace((String)ITEM_METADATA_MOVE, (String)"#{site}", (String)StringUtils.replace((String)site, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{oldPath}", (String)StringUtils.replace((String)oldPath, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{newPath}", (String)StringUtils.replace((String)newPath, (String)"'", (String)"''"));
        return sql;
    }

    public static String deleteItemMetadataRow(String site, String path) {
        String sql = StringUtils.replace((String)ITEM_METADATA_DELETE, (String)"#{site}", (String)StringUtils.replace((String)site, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{path}", (String)StringUtils.replace((String)path, (String)"'", (String)"''"));
        return sql;
    }

    public static String insertDependencyRow(String siteId, String sourcePath, String targetPath, String type) {
        String sql = StringUtils.replace((String)DEPENDENCIES_INSERT, (String)"#{site}", (String)StringUtils.replace((String)siteId, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{sourcePath}", (String)StringUtils.replace((String)sourcePath, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{targetPath}", (String)StringUtils.replace((String)targetPath, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{type}", (String)StringUtils.replace((String)type, (String)"'", (String)"''"));
        return sql;
    }

    public static String deleteDependencySourcePathRows(String siteId, String sourcePath) {
        String sql = StringUtils.replace((String)DEPENDENCIES_DELETE_SOURCE, (String)"#{site}", (String)StringUtils.replace((String)siteId, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{path}", (String)StringUtils.replace((String)sourcePath, (String)"'", (String)"''"));
        return sql;
    }

    public static String deleteDependencyRows(String siteId, String sourcePath) {
        String sql = StringUtils.replace((String)DEPENDENCIES_DELETE, (String)"#{site}", (String)StringUtils.replace((String)siteId, (String)"'", (String)"''"));
        sql = StringUtils.replace((String)sql, (String)"#{path}", (String)StringUtils.replace((String)sourcePath, (String)"'", (String)"''"));
        return sql;
    }

    private SqlStatementGeneratorUtils() {
    }
}

