/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.time.ZonedDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.service.audit.AuditService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.PaginatedResultList;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AuditController {
    private AuditService auditService;
    private SiteService siteService;

    @GetMapping(value={"/api/2/audit"})
    public ResponseBody getAuditLog(@RequestParam(value="siteId", required=false) String siteId, @RequestParam(value="siteName", required=false) String siteName, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="10") int limit, @RequestParam(value="user", required=false, defaultValue="") String user, @RequestParam(value="operations", required=false) List<String> operations, @RequestParam(value="includeParameters", required=false) boolean includeParameters, @RequestParam(value="dateFrom", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) ZonedDateTime dateFrom, @RequestParam(value="dateTo", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) ZonedDateTime dateTo, @RequestParam(value="target", required=false) String target, @RequestParam(value="origin", required=false) String origin, @RequestParam(value="clusterNodeId", required=false) String clusterNodeId, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="order", required=false) String order) throws SiteNotFoundException {
        if (StringUtils.isNotEmpty((CharSequence)siteId) && !this.siteService.existsById(siteId)) {
            throw new SiteNotFoundException("Site " + siteId + " not found.");
        }
        if (StringUtils.isNotEmpty((CharSequence)siteName) && !this.siteService.existsByName(siteName)) {
            throw new SiteNotFoundException("Site " + siteName + " not found.");
        }
        int total = this.auditService.getAuditLogTotal(siteId, siteName, user, operations, includeParameters, dateFrom, dateTo, target, origin, clusterNodeId);
        List<AuditLog> auditLog = this.auditService.getAuditLog(siteId, siteName, offset, limit, user, operations, includeParameters, dateFrom, dateTo, target, origin, clusterNodeId, sort, order);
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<AuditLog> result = new PaginatedResultList<AuditLog>();
        result.setTotal(total);
        result.setLimit(CollectionUtils.isEmpty(auditLog) ? 0 : auditLog.size());
        result.setOffset(offset);
        result.setEntities("auditLog", auditLog);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/api/2/audit/{id}"})
    public ResponseBody getAuditLogEntry(@PathVariable(value="id") long auditLogId) {
        AuditLog auditLogEntry = this.auditService.getAuditLogEntry(auditLogId);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<AuditLog> result = new ResultOne<AuditLog>();
        result.setEntity("auditLog", auditLogEntry);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    public AuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

