/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.util.List;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.service.cluster.ClusterManagementService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.ResultList;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ClusterManagementController {
    private ClusterManagementService clusterManagementService;

    @GetMapping(value={"/api/2/cluster"})
    public ResponseBody getAllMembers() throws ServiceLayerException {
        List<ClusterMember> clusterMembers = this.clusterManagementService.getAllMemebers();
        ResponseBody responseBody = new ResponseBody();
        ResultList<ClusterMember> result = new ResultList<ClusterMember>();
        result.setEntities("clusterMembers", clusterMembers);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @DeleteMapping(value={"/api/2/cluster"})
    public ResponseBody removeClusterMembers(@RequestParam(value="id") List<Long> memberIds) throws ServiceLayerException {
        boolean success = this.clusterManagementService.removeMembers(memberIds);
        ResponseBody responseBody = new ResponseBody();
        ResultOne result = new ResultOne();
        result.setResponse(ApiResponse.DELETED);
        return responseBody;
    }

    public ClusterManagementService getClusterManagementService() {
        return this.clusterManagementService;
    }

    public void setClusterManagementService(ClusterManagementService clusterManagementService) {
        this.clusterManagementService = clusterManagementService;
    }
}

