/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.CmisPathNotFoundException;
import org.craftercms.studio.api.v1.exception.CmisRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.CmisTimeoutException;
import org.craftercms.studio.api.v1.exception.CmisUnavailableException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.StudioPathNotFoundException;
import org.craftercms.studio.api.v2.dal.CmisContentItem;
import org.craftercms.studio.api.v2.exception.InvalidParametersException;
import org.craftercms.studio.api.v2.exception.configuration.ConfigurationException;
import org.craftercms.studio.api.v2.service.cmis.CmisService;
import org.craftercms.studio.impl.v2.utils.PaginationUtils;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.CmisCloneRequest;
import org.craftercms.studio.model.rest.CmisUploadItem;
import org.craftercms.studio.model.rest.PaginatedResultList;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.Result;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmisController {
    protected CmisService cmisService;

    @GetMapping(value={"/api/2/cmis/list"})
    public ResponseBody list(@RequestParam(value="siteId", required=true) String siteId, @RequestParam(value="cmisRepoId", required=true) String cmisRepoId, @RequestParam(value="path", required=false, defaultValue="") String path, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="10") int limit) throws CmisRepositoryNotFoundException, CmisTimeoutException, CmisUnavailableException, ConfigurationException {
        List<CmisContentItem> cmisContentItems = this.cmisService.list(siteId, cmisRepoId, path);
        List<CmisContentItem> paginatedItems = PaginationUtils.paginate(cmisContentItems, offset, limit, "");
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<CmisContentItem> result = new PaginatedResultList<CmisContentItem>();
        result.setTotal(cmisContentItems.size());
        result.setOffset(offset);
        result.setLimit(paginatedItems.size());
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        result.setEntities("items", paginatedItems);
        return responseBody;
    }

    @GetMapping(value={"/api/2/cmis/search"})
    public ResponseBody search(@RequestParam(value="siteId", required=true) String siteId, @RequestParam(value="cmisRepoId", required=true) String cmisRepoId, @RequestParam(value="searchTerm", required=true) String searchTerm, @RequestParam(value="path", required=false, defaultValue="") String path, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="10") int limit) throws CmisRepositoryNotFoundException, CmisTimeoutException, CmisUnavailableException, ConfigurationException {
        List<CmisContentItem> cmisContentItems = this.cmisService.search(siteId, cmisRepoId, searchTerm, path);
        List<CmisContentItem> paginatedItems = PaginationUtils.paginate(cmisContentItems, offset, limit, "");
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<CmisContentItem> result = new PaginatedResultList<CmisContentItem>();
        result.setTotal(cmisContentItems.size());
        result.setOffset(offset);
        result.setLimit(paginatedItems.size());
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        result.setEntities("items", paginatedItems);
        return responseBody;
    }

    @PostMapping(value={"/api/2/cmis/clone"})
    public ResponseBody cloneContent(@RequestBody CmisCloneRequest cmisCloneRequest) throws CmisUnavailableException, CmisTimeoutException, CmisRepositoryNotFoundException, StudioPathNotFoundException, ServiceLayerException, CmisPathNotFoundException {
        this.cmisService.cloneContent(cmisCloneRequest.getSiteId(), cmisCloneRequest.getCmisRepoId(), cmisCloneRequest.getCmisPath(), cmisCloneRequest.getStudioPath());
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/api/2/cmis/upload"})
    public ResponseBody uploadContent(HttpServletRequest httpServletRequest) throws IOException, CmisUnavailableException, CmisPathNotFoundException, CmisTimeoutException, CmisRepositoryNotFoundException, FileUploadException, InvalidParametersException, ConfigurationException {
        ServletFileUpload servletFileUpload = new ServletFileUpload();
        FileItemIterator itemIterator = servletFileUpload.getItemIterator(httpServletRequest);
        String filename = "";
        String siteId = "";
        String cmisRepoId = "";
        String cmisPath = "";
        CmisUploadItem cmisUploadItem = new CmisUploadItem();
        while (itemIterator.hasNext()) {
            FileItemStream item = itemIterator.next();
            String name = item.getFieldName();
            InputStream stream = item.openStream();
            Throwable throwable = null;
            try {
                if (item.isFormField()) {
                    switch (name) {
                        case "siteId": {
                            siteId = Streams.asString((InputStream)stream);
                            break;
                        }
                        case "cmisRepoId": {
                            cmisRepoId = Streams.asString((InputStream)stream);
                            break;
                        }
                        case "cmisPath": {
                            cmisPath = Streams.asString((InputStream)stream);
                            break;
                        }
                    }
                    continue;
                }
                filename = item.getName();
                if (StringUtils.isEmpty((CharSequence)siteId)) {
                    throw new InvalidParametersException("Invalid siteId");
                }
                if (StringUtils.isEmpty((CharSequence)cmisRepoId)) {
                    throw new InvalidParametersException("Invalid cmisRepoId");
                }
                if (StringUtils.isEmpty((CharSequence)cmisPath)) {
                    throw new InvalidParametersException("Invalid cmisPath");
                }
                cmisUploadItem = this.cmisService.uploadContent(siteId, cmisRepoId, cmisPath, filename, stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        ResponseBody responseBody = new ResponseBody();
        ResultOne<CmisUploadItem> result = new ResultOne<CmisUploadItem>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("item", cmisUploadItem);
        responseBody.setResult(result);
        return responseBody;
    }

    public CmisService getCmisService() {
        return this.cmisService;
    }

    public void setCmisService(CmisService cmisService) {
        this.cmisService = cmisService;
    }
}

