/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v2.service.config.ConfigurationService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ConfigurationHistory;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.Result;
import org.craftercms.studio.model.rest.ResultOne;
import org.craftercms.studio.model.rest.WriteConfigurationRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/configuration"})
public class ConfigurationController {
    private ConfigurationService configurationService;
    private StudioConfiguration studioConfiguration;

    @GetMapping(value={"/get_configuration"})
    public ResponseBody getConfiguration(@RequestParam(name="siteId", required=true) String siteId, @RequestParam(name="module", required=true) String module, @RequestParam(name="path", required=true) String path, @RequestParam(name="environment", required=false) String environment) {
        String content = "";
        content = StringUtils.equals((CharSequence)siteId, (CharSequence)this.studioConfiguration.getProperty("studio.configuration.global.systemSite")) ? this.configurationService.getGlobalConfiguration(path) : this.configurationService.getConfigurationAsString(siteId, module, path, environment);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<String> result = new ResultOne<String>();
        result.setEntity("content", content);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/write_configuration"})
    public ResponseBody writeConfiguration(@RequestBody WriteConfigurationRequest wcRequest) throws ServiceLayerException {
        InputStream is = IOUtils.toInputStream((String)wcRequest.getContent());
        String siteId = wcRequest.getSiteId();
        if (StringUtils.equals((CharSequence)siteId, (CharSequence)this.studioConfiguration.getProperty("studio.configuration.global.systemSite"))) {
            this.configurationService.writeGlobalConfiguration(wcRequest.getPath(), is);
        } else {
            this.configurationService.writeConfiguration(siteId, wcRequest.getModule(), wcRequest.getPath(), wcRequest.getEnvironment(), is);
        }
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/get_configuration_history"})
    public ResponseBody getConfigurationHistory(@RequestParam(name="siteId", required=true) String siteId, @RequestParam(name="module", required=true) String module, @RequestParam(name="path", required=true) String path, @RequestParam(name="environment", required=false) String environment) {
        ConfigurationHistory history = this.configurationService.getConfigurationHistory(siteId, module, path, environment);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<ConfigurationHistory> result = new ResultOne<ConfigurationHistory>();
        result.setEntity("history", history);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

