/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.QuickCreateItem;
import org.craftercms.studio.api.v2.service.content.ContentService;
import org.craftercms.studio.api.v2.service.dependency.DependencyService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.Result;
import org.craftercms.studio.model.rest.ResultList;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/content"})
public class ContentController {
    private ContentService contentService;
    private SiteService siteService;
    private DependencyService dependencyService;

    @GetMapping(value={"/list_quick_create_content"})
    public ResponseBody listQuickCreateContent(@RequestParam(name="siteId", required=true) String siteId) throws SiteNotFoundException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        List<QuickCreateItem> items = this.contentService.getQuickCreatableContentTypes(siteId);
        ResponseBody responseBody = new ResponseBody();
        ResultList<QuickCreateItem> result = new ResultList<QuickCreateItem>();
        result.setResponse(ApiResponse.OK);
        result.setEntities("items", items);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/get_delete_package"})
    public ResponseBody getDeletePackage(@RequestParam(value="siteId", required=true) String siteId, @RequestParam(value="paths", required=true) List<String> paths) {
        List<Object> childItems = new ArrayList();
        List<Object> dependentItems = new ArrayList();
        if (CollectionUtils.isNotEmpty(paths)) {
            childItems = this.contentService.getChildItems(siteId, paths);
            dependentItems = this.dependencyService.getDependentItems(siteId, paths);
        }
        ResponseBody responseBody = new ResponseBody();
        ResultOne result = new ResultOne();
        result.setResponse(ApiResponse.OK);
        HashMap items = new HashMap();
        items.put("childItems", childItems);
        items.put("dependentItems", dependentItems);
        result.setEntity("items", items);
        responseBody.setResult(result);
        return responseBody;
    }

    @DeleteMapping(value={"/delete"})
    public ResponseBody delete(@RequestParam(value="siteId", required=true) String siteId, @RequestParam(value="paths", required=true) List<String> paths, @RequestParam(value="submissionComment", required=false) String submissionComment) throws DeploymentException, AuthenticationException, ServiceLayerException {
        this.contentService.deleteContent(siteId, paths, submissionComment);
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.DELETED);
        responseBody.setResult(result);
        return responseBody;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }
}

