/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.service.dashboard.DashboardService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.PaginatedResultList;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.dashboard.AuditDashboardItem;
import org.craftercms.studio.model.rest.dashboard.AuditDashboardRequestParameters;
import org.craftercms.studio.model.rest.dashboard.ContentDashboardItem;
import org.craftercms.studio.model.rest.dashboard.ContentDashboardRequestParameters;
import org.craftercms.studio.model.rest.dashboard.PublishingDashboardItem;
import org.craftercms.studio.model.rest.dashboard.PublishingDashboardRequestParameters;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/dashboard"})
public class DashboardController {
    private DashboardService dashboardService;

    @GetMapping(value={"/audit"}, produces={"application/json"})
    public ResponseBody getAuditDashboard(@Valid AuditDashboardRequestParameters requestParameters) {
        String user = null;
        List<String> operations = null;
        ZonedDateTime dateFrom = null;
        ZonedDateTime dateTo = null;
        String target = null;
        if (requestParameters.getFilters() != null) {
            user = requestParameters.getFilters().getActor();
            operations = requestParameters.getFilters().getOperations();
            dateFrom = requestParameters.getFilters().getOperationTimestampFrom();
            dateTo = requestParameters.getFilters().getOperationTimestampTo();
            target = requestParameters.getFilters().getTarget();
        }
        int total = this.dashboardService.getAuditDashboardTotal(requestParameters.getSiteId(), user, operations, dateFrom, dateTo, target);
        List<AuditLog> auditLog = this.dashboardService.getAuditDashboard(requestParameters.getSiteId(), requestParameters.getOffset(), requestParameters.getLimit(), user, operations, dateFrom, dateTo, target, requestParameters.getSortBy(), requestParameters.getOrder());
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<AuditDashboardItem> result = new PaginatedResultList<AuditDashboardItem>();
        result.setTotal(total);
        result.setLimit(CollectionUtils.isEmpty(auditLog) ? 0 : auditLog.size());
        result.setOffset(requestParameters.getOffset());
        result.setEntities("items", this.prepareAuditResult(auditLog));
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    private List<AuditDashboardItem> prepareAuditResult(List<AuditLog> auditLogs) {
        ArrayList<AuditDashboardItem> resultItems = new ArrayList<AuditDashboardItem>();
        for (AuditLog auditLog : auditLogs) {
            AuditDashboardItem item = new AuditDashboardItem();
            item.setSiteId(auditLog.getSiteName());
            item.setActor(auditLog.getActorId());
            item.setOperation(auditLog.getOperation());
            item.setOperationTimestamp(auditLog.getOperationTimestamp());
            item.setTarget(auditLog.getPrimaryTargetValue());
            resultItems.add(item);
        }
        return resultItems;
    }

    @GetMapping(value={"/publishing"}, produces={"application/json"})
    public ResponseBody getPublishingDashboard(@Valid PublishingDashboardRequestParameters requestParameters) {
        String user = null;
        String environment = null;
        String path = null;
        ZonedDateTime dateFrom = null;
        ZonedDateTime dateTo = null;
        String contentType = null;
        long state = 0L;
        if (requestParameters.getFilters() != null) {
            user = requestParameters.getFilters().getPublisher();
            path = requestParameters.getFilters().getPath();
            environment = requestParameters.getFilters().getEnvironment();
            dateFrom = requestParameters.getFilters().getPublishedDateFrom();
            dateTo = requestParameters.getFilters().getPublishedDateTo();
            contentType = requestParameters.getFilters().getContentType();
        }
        int total = 0;
        List<PublishingDashboardItem> publishingHistory = this.dashboardService.getPublishingHistory(requestParameters.getSiteId(), environment, path, user, dateFrom, dateTo, contentType, state, requestParameters.getSortBy(), requestParameters.getOrder(), requestParameters.getOffset(), requestParameters.getLimit());
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<PublishingDashboardItem> result = new PaginatedResultList<PublishingDashboardItem>();
        result.setTotal(total);
        result.setLimit(CollectionUtils.isEmpty(publishingHistory) ? 0 : publishingHistory.size());
        result.setOffset(requestParameters.getOffset());
        result.setEntities("items", publishingHistory);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/content"}, produces={"application/json"})
    public ResponseBody getContentDashboard(@Valid ContentDashboardRequestParameters requestParameters) {
        String modifier = null;
        String path = null;
        ZonedDateTime dateFrom = null;
        ZonedDateTime dateTo = null;
        String contentType = null;
        long state = 0L;
        if (requestParameters.getFilters() != null) {
            modifier = requestParameters.getFilters().getModifier();
            path = requestParameters.getFilters().getPath();
            dateFrom = requestParameters.getFilters().getModifiedDateFrom();
            dateTo = requestParameters.getFilters().getModifiedDateTo();
            contentType = requestParameters.getFilters().getContentType();
            state = requestParameters.getFilters().getState();
        }
        int total = this.dashboardService.getContentDashboardTotal(requestParameters.getSiteId(), path, modifier, contentType, state, dateFrom, dateTo);
        List<ContentDashboardItem> contentDashboardItems = this.dashboardService.getContentDashboard(requestParameters.getSiteId(), path, modifier, contentType, state, dateFrom, dateTo, requestParameters.getSortBy(), requestParameters.getOrder(), requestParameters.getOffset(), requestParameters.getLimit());
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<ContentDashboardItem> result = new PaginatedResultList<ContentDashboardItem>();
        result.setTotal(total);
        result.setLimit(CollectionUtils.isEmpty(contentDashboardItems) ? 0 : contentDashboardItems.size());
        result.setOffset(requestParameters.getOffset());
        result.setEntities("items", contentDashboardItems);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    public DashboardService getDashboardService() {
        return this.dashboardService;
    }

    public void setDashboardService(DashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }
}

