/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v2.service.dependency.DependencyService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/dependency"})
public class DependencyController {
    private DependencyService dependencyService;

    @GetMapping(value={"/dependencies"})
    public ResponseBody getSoftDependencies(@RequestParam(value="siteId", required=true) String siteId, @RequestParam(value="paths", required=true) List<String> paths) throws ServiceLayerException {
        List<String> softDeps = this.dependencyService.getSoftDependencies(siteId, paths);
        List<String> hardDeps = this.dependencyService.getHardDependencies(siteId, paths);
        List filteredSoftDeps = softDeps.stream().filter(sd -> !hardDeps.contains(sd)).collect(Collectors.toList());
        ResponseBody responseBody = new ResponseBody();
        ResultOne result = new ResultOne();
        result.setResponse(ApiResponse.OK);
        HashMap<String, List<String>> items = new HashMap<String, List<String>>();
        items.put("hardDependencies", hardDeps);
        items.put("softDependencies", filteredSoftDeps);
        result.setEntity("items", items);
        responseBody.setResult(result);
        return responseBody;
    }

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }
}

