/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import com.fasterxml.jackson.core.JsonProcessingException;
import javax.servlet.http.HttpServletRequest;
import org.craftercms.commons.exceptions.InvalidManagementTokenException;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.security.exception.ActionDeniedException;
import org.craftercms.studio.api.v1.exception.CmisPathNotFoundException;
import org.craftercms.studio.api.v1.exception.CmisRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.CmisTimeoutException;
import org.craftercms.studio.api.v1.exception.CmisUnavailableException;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.StudioPathNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.repository.RemoteNotRemovableException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.exception.ClusterMemberAlreadyExistsException;
import org.craftercms.studio.api.v2.exception.ClusterMemberNotFoundException;
import org.craftercms.studio.api.v2.exception.InvalidParametersException;
import org.craftercms.studio.api.v2.exception.OrganizationNotFoundException;
import org.craftercms.studio.api.v2.exception.PasswordRequirementsFailedException;
import org.craftercms.studio.api.v2.exception.PullFromRemoteConflictException;
import org.craftercms.studio.api.v2.exception.SystemToolException;
import org.craftercms.studio.api.v2.exception.configuration.InvalidConfigurationException;
import org.craftercms.studio.api.v2.exception.marketplace.MarketplaceNotInitializedException;
import org.craftercms.studio.api.v2.exception.marketplace.MarketplaceUnreachableException;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.Result;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Order(value=-2147483648)
@RestControllerAdvice(value={"org.craftercms.studio.controller.rest.v2"})
public class ExceptionHandlers {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandlers.class);

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseBody handleAuthenticationException(HttpServletRequest request, AuthenticationException e) {
        return this.handleExceptionInternal(request, e, ApiResponse.UNAUTHENTICATED);
    }

    @ExceptionHandler(value={ActionDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public ResponseBody handleActionDeniedException(HttpServletRequest request, ActionDeniedException e) {
        return this.handleExceptionInternal(request, (Exception)e, ApiResponse.UNAUTHORIZED);
    }

    @ExceptionHandler(value={UserAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    public ResponseBody handleUserAlreadyExistsException(HttpServletRequest request, UserAlreadyExistsException e) {
        ApiResponse response = new ApiResponse(ApiResponse.USER_ALREADY_EXISTS);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={UserNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseBody handleUserNotFoundException(HttpServletRequest request, UserNotFoundException e) {
        ApiResponse response = new ApiResponse(ApiResponse.USER_NOT_FOUND);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={GroupAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    public ResponseBody handleGroupAlreadyExistsException(HttpServletRequest request, GroupAlreadyExistsException e) {
        ApiResponse response = new ApiResponse(ApiResponse.GROUP_ALREADY_EXISTS);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={InvalidParametersException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handleInvalidParametersException(HttpServletRequest request, InvalidParametersException e) {
        ApiResponse response = new ApiResponse(ApiResponse.INVALID_PARAMS);
        response.setMessage(response.getMessage() + " : " + e.getMessage());
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={MarketplaceNotInitializedException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseBody handleMarketplaceNotInitializedException(HttpServletRequest request, MarketplaceNotInitializedException e) {
        ApiResponse response = new ApiResponse(ApiResponse.MARKETPLACE_NOT_INITIALIZED);
        response.setMessage(response.getMessage() + ": " + e.getMessage());
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={MarketplaceUnreachableException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseBody handleMarketplaceUnreachableException(HttpServletRequest request, MarketplaceUnreachableException e) {
        ApiResponse response = new ApiResponse(ApiResponse.MARKETPLACE_UNREACHABLE);
        response.setMessage(response.getMessage() + ": " + e.getMessage());
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={ServiceLayerException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseBody handleServiceException(HttpServletRequest request, ServiceLayerException e) {
        ApiResponse response = new ApiResponse(ApiResponse.INTERNAL_SYSTEM_FAILURE);
        response.setMessage(response.getMessage() + ": " + e.getMessage());
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={OrganizationNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseBody handleOrganizetionNotFoundException(HttpServletRequest request, OrganizationNotFoundException e) {
        ApiResponse response = new ApiResponse(ApiResponse.ORG_NOT_FOUND);
        response.setMessage(response.getMessage() + ": " + e.getMessage());
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={GroupNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseBody handleGroupNotFoundException(HttpServletRequest request, GroupNotFoundException e) {
        ApiResponse response = new ApiResponse(ApiResponse.GROUP_NOT_FOUND);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={JsonProcessingException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handleUnrecognizedPropertyException(HttpServletRequest request, JsonProcessingException e) {
        ApiResponse response = new ApiResponse(ApiResponse.INVALID_PARAMS);
        return this.handleExceptionInternal(request, (Exception)e, response);
    }

    @ExceptionHandler(value={ClusterMemberNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseBody handleClusterMemberNotFoundException(HttpServletRequest request, ClusterMemberNotFoundException e) {
        ApiResponse response = new ApiResponse(ApiResponse.CLUSTER_MEMBER_NOT_FOUND);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={ClusterMemberAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    public ResponseBody handleClusterMemberAlreadyExistsException(HttpServletRequest request, ClusterMemberAlreadyExistsException e) {
        ApiResponse response = new ApiResponse(ApiResponse.CLUSTER_MEMBER_ALREADY_EXISTS);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={SiteNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseBody handleSiteNotFoundException(HttpServletRequest request, SiteNotFoundException e) {
        ApiResponse response = new ApiResponse(ApiResponse.PROJECT_NOT_FOUND);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={RemoteAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    public ResponseBody handleRemoteAlreadyExistsException(HttpServletRequest request, RemoteAlreadyExistsException e) {
        ApiResponse response = new ApiResponse(ApiResponse.REMOTE_REPOSITORY_ALREADY_EXISTS);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={InvalidRemoteUrlException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handleInvalidRemoteUrlException(HttpServletRequest request, InvalidRemoteUrlException e) {
        ApiResponse response = new ApiResponse(ApiResponse.INVALID_PARAMS);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={CmisRepositoryNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseBody handleCmisRepositoryNotFoundException(HttpServletRequest request, CmisRepositoryNotFoundException e) {
        ApiResponse response = new ApiResponse(ApiResponse.CMIS_NOT_FOUND);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={CmisTimeoutException.class})
    @ResponseStatus(value=HttpStatus.REQUEST_TIMEOUT)
    public ResponseBody handleCmisTimeoutException(HttpServletRequest request, CmisTimeoutException e) {
        ApiResponse response = new ApiResponse(ApiResponse.CMIS_TIMEOUT);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={CmisUnavailableException.class})
    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    public ResponseBody handleCmisUnavailableException(HttpServletRequest request, CmisUnavailableException e) {
        ApiResponse response = new ApiResponse(ApiResponse.CMIS_UNREACHABLE);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={StudioPathNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseBody handleStudioPathNotFoundException(HttpServletRequest request, StudioPathNotFoundException e) {
        ApiResponse response = new ApiResponse(ApiResponse.CMIS_STUDIO_PATH_NOT_FOUND);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={CmisPathNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseBody handleCmisPathNotFoundException(HttpServletRequest request, CmisPathNotFoundException e) {
        ApiResponse response = new ApiResponse(ApiResponse.CONTENT_NOT_FOUND);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={PasswordRequirementsFailedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handlePasswordRequirementsFailedException(HttpServletRequest request, PasswordRequirementsFailedException e) {
        ApiResponse response = new ApiResponse(ApiResponse.USER_PASSWORD_REQUIREMENTS_FAILED);
        return this.handleExceptionInternal(request, e, response, "debug");
    }

    @ExceptionHandler(value={PasswordDoesNotMatchException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseBody handlePasswordDoesNotMatchException(HttpServletRequest request, PasswordDoesNotMatchException e) {
        ApiResponse response = new ApiResponse(ApiResponse.USER_PASSWORD_DOES_NOT_MATCH);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={PullFromRemoteConflictException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    public ResponseBody handlePullFromRemoteConflictException(HttpServletRequest request, PullFromRemoteConflictException e) {
        ApiResponse response = new ApiResponse(ApiResponse.PULL_FROM_REMOTE_REPOSITORY_CONFLICT);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={ContentNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseBody handleContentNotFoundException(HttpServletRequest request, ContentNotFoundException e) {
        ApiResponse response = new ApiResponse(ApiResponse.CONTENT_NOT_FOUND);
        response.setRemedialAction(String.format("Check that path '%s' is correct and it exists in site '%s'", e.getPath(), e.getSite()));
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handleMissingServletRequestParameterException(HttpServletRequest request, MissingServletRequestParameterException e) {
        ApiResponse response = new ApiResponse(ApiResponse.INVALID_PARAMS);
        response.setRemedialAction(String.format("Add missing parameter '%s' of type '%s'", e.getParameterName(), e.getParameterType()));
        return this.handleExceptionInternal(request, (Exception)e, response);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handleMissingServletRequestParameterException(HttpServletRequest request, MethodArgumentNotValidException e) {
        ApiResponse response = new ApiResponse(ApiResponse.INVALID_PARAMS);
        return this.handleExceptionInternal(request, (Exception)e, response);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handleHttpMessageNotReadableException(HttpServletRequest request, HttpMessageNotReadableException e) {
        ApiResponse response = new ApiResponse(ApiResponse.INVALID_PARAMS);
        return this.handleExceptionInternal(request, (Exception)e, response);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handleMethodArgumentTypeMismatchException(HttpServletRequest request, MethodArgumentTypeMismatchException e) {
        ApiResponse response = new ApiResponse(ApiResponse.INVALID_PARAMS);
        return this.handleExceptionInternal(request, (Exception)e, response);
    }

    @ExceptionHandler(value={InvalidManagementTokenException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseBody handleInvalidManagementTokenException(HttpServletRequest request, InvalidManagementTokenException e) {
        ApiResponse response = new ApiResponse(ApiResponse.UNAUTHORIZED);
        return this.handleExceptionInternal(request, (Exception)e, response);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handleBeanPropertyBindingResult(HttpServletRequest request, BindException e) {
        ApiResponse response = new ApiResponse(ApiResponse.INVALID_PARAMS);
        return this.handleExceptionInternal(request, (Exception)e, response);
    }

    @ExceptionHandler(value={RemoteNotRemovableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handleRemoteNotRemovableException(HttpServletRequest request, RemoteNotRemovableException e) {
        ApiResponse response = new ApiResponse(ApiResponse.REMOTE_REPOSITORY_NOT_REMOVABLE);
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={SystemToolException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseBody handleSystemToolException(HttpServletRequest request, SystemToolException e) {
        return this.handleExceptionInternal(request, e, null, "debug");
    }

    @ExceptionHandler(value={InvalidConfigurationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseBody handleInvalidConfigurationException(HttpServletRequest request, InvalidConfigurationException e) {
        ApiResponse response = new ApiResponse(ApiResponse.INVALID_PARAMS);
        response.setMessage(response.getMessage() + ": " + e.getMessage());
        return this.handleExceptionInternal(request, e, response);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseBody handleException(HttpServletRequest request, Exception e) {
        ApiResponse response = new ApiResponse(ApiResponse.INTERNAL_SYSTEM_FAILURE);
        return this.handleExceptionInternal(request, e, response);
    }

    protected ResponseBody handleExceptionInternal(HttpServletRequest request, Exception e, ApiResponse response) {
        return this.handleExceptionInternal(request, e, response, "error");
    }

    protected ResponseBody handleExceptionInternal(HttpServletRequest request, Exception e, ApiResponse response, String logLevel) {
        switch (logLevel) {
            case "off": {
                break;
            }
            case "debug": {
                logger.debug("API endpoint " + HttpUtils.getFullRequestUri((HttpServletRequest)request, (boolean)true) + " failed with response: " + response, new Object[0]);
                break;
            }
            case "warn": {
                logger.warn("API endpoint " + HttpUtils.getFullRequestUri((HttpServletRequest)request, (boolean)true) + " failed with response: " + response, new Object[0]);
                break;
            }
            case "info": {
                logger.info("API endpoint " + HttpUtils.getFullRequestUri((HttpServletRequest)request, (boolean)true) + " failed with response: " + response, new Object[0]);
                break;
            }
            case "error": {
                logger.error("API endpoint " + HttpUtils.getFullRequestUri((HttpServletRequest)request, (boolean)true) + " failed with response: " + response, e, new Object[0]);
                break;
            }
        }
        Result result = new Result();
        result.setResponse(response);
        ResponseBody responseBody = new ResponseBody();
        responseBody.setResult(result);
        return responseBody;
    }
}

