/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.GroupNotFoundException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.exception.OrganizationNotFoundException;
import org.craftercms.studio.api.v2.service.security.GroupService;
import org.craftercms.studio.controller.rest.v2.ValidationUtils;
import org.craftercms.studio.model.rest.AddGroupMembers;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.PaginatedResultList;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.Result;
import org.craftercms.studio.model.rest.ResultList;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GroupsController {
    private static final Logger logger = LoggerFactory.getLogger(GroupsController.class);
    private GroupService groupService;

    @GetMapping(value={"/api/2/groups"})
    public ResponseBody getAllGroups(@RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="10") int limit, @RequestParam(value="sort", required=false, defaultValue="") String sort) throws ServiceLayerException, OrganizationNotFoundException {
        int total = 0;
        total = this.groupService.getAllGroupsTotal(1L);
        List<Group> groups = this.groupService.getAllGroups(1L, offset, limit, sort);
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<Group> result = new PaginatedResultList<Group>();
        result.setTotal(total);
        result.setOffset(offset);
        result.setLimit(CollectionUtils.isEmpty(groups) ? 0 : groups.size());
        result.setResponse(ApiResponse.OK);
        result.setEntities("groups", groups);
        responseBody.setResult(result);
        return responseBody;
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/api/2/groups"}, consumes={"application/json"})
    public ResponseBody createGroup(@RequestBody Group group) throws GroupAlreadyExistsException, ServiceLayerException, AuthenticationException {
        Group newGroup = this.groupService.createGroup(1L, group.getGroupName(), group.getGroupDescription());
        ResponseBody responseBody = new ResponseBody();
        ResultOne<Group> result = new ResultOne<Group>();
        result.setResponse(ApiResponse.CREATED);
        result.setEntity("group", newGroup);
        responseBody.setResult(result);
        return responseBody;
    }

    @PatchMapping(value={"/api/2/groups"}, consumes={"application/json"})
    public ResponseBody updateGroup(@RequestBody Group group) throws ServiceLayerException, GroupNotFoundException, AuthenticationException {
        ResponseBody responseBody = new ResponseBody();
        Group updatedGroup = this.groupService.updateGroup(1L, group);
        ResultOne<Group> result = new ResultOne<Group>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("group", updatedGroup);
        responseBody.setResult(result);
        return responseBody;
    }

    @DeleteMapping(value={"/api/2/groups"})
    public ResponseBody deleteGroup(@RequestParam(value="id") List<Long> groupIds) throws ServiceLayerException, GroupNotFoundException, AuthenticationException {
        this.groupService.deleteGroup(groupIds);
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.DELETED);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/api/2/groups/{id}"})
    public ResponseBody getGroup(@PathVariable(value="id") int groupId) throws ServiceLayerException, GroupNotFoundException {
        Group group = this.groupService.getGroup(groupId);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<Group> result = new ResultOne<Group>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("group", group);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/api/2/groups/{id}/members"})
    public ResponseBody getGroupMembers(@PathVariable(value="id") int groupId, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="10") int limit, @RequestParam(value="sort", required=false, defaultValue="") String sort) throws ServiceLayerException, GroupNotFoundException {
        int total = this.groupService.getGroupMembersTotal(groupId);
        List<User> users = this.groupService.getGroupMembers(groupId, offset, limit, sort);
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<User> result = new PaginatedResultList<User>();
        result.setResponse(ApiResponse.OK);
        result.setTotal(total);
        result.setOffset(offset);
        result.setLimit(limit);
        result.setEntities("users", users);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/api/2/groups/{id}/members"}, consumes={"application/json"})
    public ResponseBody addGroupMembers(@PathVariable(value="id") int groupId, @RequestBody AddGroupMembers addGroupMembers) throws ServiceLayerException, UserNotFoundException, GroupNotFoundException, AuthenticationException {
        ValidationUtils.validateAddGroupMembers(addGroupMembers);
        List<User> addedUsers = this.groupService.addGroupMembers(groupId, addGroupMembers.getIds(), addGroupMembers.getUsernames());
        ResponseBody responseBody = new ResponseBody();
        ResultList<User> result = new ResultList<User>();
        result.setResponse(ApiResponse.OK);
        result.setEntities("users", addedUsers);
        responseBody.setResult(result);
        return responseBody;
    }

    @DeleteMapping(value={"/api/2/groups/{id}/members"})
    public ResponseBody removeGroupMembers(@PathVariable(value="id") int groupId, @RequestParam(value="userId", required=false) List<Long> userIds, @RequestParam(value="username", required=false) List<String> usernames) throws ServiceLayerException, UserNotFoundException, GroupNotFoundException, AuthenticationException {
        ValidationUtils.validateAnyListNonEmpty(userIds, usernames);
        this.groupService.removeGroupMembers(groupId, userIds != null ? userIds : Collections.emptyList(), usernames != null ? usernames : Collections.emptyList());
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.DELETED);
        responseBody.setResult(result);
        return responseBody;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }
}

