/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.util.List;
import java.util.Map;
import org.craftercms.studio.api.v2.exception.marketplace.MarketplaceException;
import org.craftercms.studio.api.v2.service.marketplace.MarketplaceService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.PaginatedResultList;
import org.craftercms.studio.model.rest.ResponseBody;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/marketplace"})
public class MarketplaceController {
    protected MarketplaceService marketplaceService;

    public MarketplaceController(MarketplaceService marketplaceService) {
        this.marketplaceService = marketplaceService;
    }

    @GetMapping(value={"/search"})
    public ResponseBody searchPlugins(@RequestParam(required=false) String type, @RequestParam(required=false) String keywords, @RequestParam(required=false, defaultValue="false") boolean showIncompatible, @RequestParam(required=false, defaultValue="0") long offset, @RequestParam(required=false, defaultValue="10") long limit) throws MarketplaceException {
        Map<String, Object> page = this.marketplaceService.searchPlugins(type, keywords, showIncompatible, offset, limit);
        ResponseBody response = new ResponseBody();
        PaginatedResultList result = new PaginatedResultList();
        result.setResponse(ApiResponse.OK);
        result.setEntities("plugins", (List)page.get("items"));
        result.setTotal((Integer)page.get("total"));
        result.setOffset((int)offset);
        result.setLimit((int)limit);
        response.setResult(result);
        return response;
    }
}

