/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.exceptions.InvalidManagementTokenException;
import org.craftercms.commons.monitoring.MemoryInfo;
import org.craftercms.commons.monitoring.StatusInfo;
import org.craftercms.commons.monitoring.VersionInfo;
import org.craftercms.engine.util.logging.CircularQueueLogAppender;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v2.exception.InvalidParametersException;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResultList;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2"})
public class MonitoringController {
    private StudioConfiguration studioConfiguration;
    private SecurityService securityService;

    protected void validateToken(String token) throws InvalidManagementTokenException, InvalidParametersException {
        if (StringUtils.isEmpty((CharSequence)this.securityService.getCurrentUser())) {
            if (Objects.isNull(token)) {
                throw new InvalidParametersException("Missing parameter: 'token'");
            }
            if (!StringUtils.equals((CharSequence)token, (CharSequence)this.getConfiguredToken())) {
                throw new InvalidManagementTokenException("Management authorization failed, invalid token.");
            }
        }
    }

    @GetMapping(value={"/monitoring/memory"})
    public ResultOne<MemoryInfo> getCurrentMemory(@RequestParam(name="token", required=false) String token) throws InvalidManagementTokenException, InvalidParametersException {
        this.validateToken(token);
        ResultOne<MemoryInfo> result = new ResultOne<MemoryInfo>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("memory", MemoryInfo.getCurrentMemory());
        return result;
    }

    @GetMapping(value={"/monitoring/status"})
    public ResultOne<StatusInfo> getCurrentStatus(@RequestParam(name="token", required=false) String token) throws InvalidManagementTokenException, InvalidParametersException {
        this.validateToken(token);
        ResultOne<StatusInfo> result = new ResultOne<StatusInfo>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("status", StatusInfo.getCurrentStatus());
        return result;
    }

    @GetMapping(value={"/monitoring/version"})
    public ResultOne<VersionInfo> getCurrentVersion(@RequestParam(name="token", required=false) String token) throws InvalidManagementTokenException, IOException, InvalidParametersException {
        this.validateToken(token);
        ResultOne<VersionInfo> result = new ResultOne<VersionInfo>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("version", VersionInfo.getVersion(this.getClass()));
        return result;
    }

    @GetMapping(value={"/monitoring/log"}, produces={"application/json"})
    public ResultList<Map<String, Object>> getLogEvents(@RequestParam long since, @RequestParam(name="token", required=false) String token) throws InvalidManagementTokenException, InvalidParametersException {
        this.validateToken(token);
        ResultList<Map<String, Object>> result = new ResultList<Map<String, Object>>();
        result.setResponse(ApiResponse.OK);
        result.setEntities("events", CircularQueueLogAppender.getLoggedEvents("craftercms", since));
        return result;
    }

    protected String getConfiguredToken() {
        return this.studioConfiguration.getProperty("studio.configuration.management.authorizationToken");
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

