/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
public class ProxyController {
    protected final StudioConfiguration studioConfiguration;
    protected final ServicesConfig servicesConfig;
    protected final RestTemplate restTemplate = new RestTemplate();

    public ProxyController(StudioConfiguration studioConfiguration, ServicesConfig servicesConfig) {
        this.studioConfiguration = studioConfiguration;
        this.servicesConfig = servicesConfig;
    }

    @RequestMapping(value={"/engine/**"})
    public ResponseEntity<Object> proxyEngine(@RequestBody(required=false) String body, @RequestParam(value="crafterSite") String siteId, HttpMethod method, HttpServletRequest request) throws URISyntaxException {
        String requestUrl = request.getRequestURI();
        String proxiedUrl = StringUtils.replace((String)requestUrl, (String)request.getContextPath(), (String)"");
        proxiedUrl = StringUtils.replace((String)proxiedUrl, (String)"/engine", (String)"");
        List<String> engineProtectedUrls = this.getEngineProtectedUrls();
        boolean managementTokenRequired = engineProtectedUrls.contains(proxiedUrl);
        URI uri = new URI(this.getAuthoringUrl(siteId));
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)uri).path(proxiedUrl).query(request.getQueryString());
        if (managementTokenRequired) {
            uriComponentsBuilder = uriComponentsBuilder.queryParam("token", new Object[]{this.getEngineManagementTokenValue()});
        }
        uri = uriComponentsBuilder.build(true).toUri();
        HttpHeaders headers = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.set(headerName, request.getHeader(headerName));
        }
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            return this.restTemplate.exchange(uri, method, httpEntity, Object.class);
        }
        catch (HttpStatusCodeException e) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)e.getRawStatusCode()).headers(e.getResponseHeaders())).body((Object)e.getResponseBodyAsString());
        }
    }

    protected String getAuthoringUrl(String siteId) {
        return this.servicesConfig.getAuthoringUrl(siteId);
    }

    protected String getEngineManagementTokenValue() {
        return this.studioConfiguration.getProperty("studio.configuration.management.previewAuthorizationToken");
    }

    protected List<String> getEngineProtectedUrls() {
        return Arrays.asList(this.studioConfiguration.getProperty("studio.configuration.management.previewProtectedUrls").split(","));
    }
}

