/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.DeploymentHistoryGroup;
import org.craftercms.studio.api.v2.dal.PublishStatus;
import org.craftercms.studio.api.v2.dal.PublishingPackageDetails;
import org.craftercms.studio.api.v2.service.publish.PublishService;
import org.craftercms.studio.api.v2.service.site.SitesService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.CancelPublishingPackagesRequest;
import org.craftercms.studio.model.rest.ClearPublishingLockRequest;
import org.craftercms.studio.model.rest.PaginatedResultList;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.Result;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/publish"})
public class PublishController {
    private PublishService publishService;
    private SiteService siteService;
    private SitesService sitesService;

    @GetMapping(value={"/packages"})
    public ResponseBody getPublishingPackages(@RequestParam(name="siteId", required=true) String siteId, @RequestParam(name="environment", required=false) String environment, @RequestParam(name="path", required=false) String path, @RequestParam(name="states", required=false) List<String> states, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit) throws SiteNotFoundException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        int total = this.publishService.getPublishingPackagesTotal(siteId, environment, path, states);
        List<Object> packages = new ArrayList();
        if (total > 0) {
            packages = this.publishService.getPublishingPackages(siteId, environment, path, states, offset, limit);
        }
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<Object> result = new PaginatedResultList<Object>();
        result.setTotal(total);
        result.setOffset(offset);
        result.setLimit(CollectionUtils.isEmpty(packages) ? 0 : packages.size());
        result.setResponse(ApiResponse.OK);
        result.setEntities("packages", packages);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/package"})
    public ResponseBody getPublishingPackageDetails(@RequestParam(name="siteId") String siteId, @RequestParam(name="packageId") String packageId) throws SiteNotFoundException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        PublishingPackageDetails publishingPackageDetails = this.publishService.getPublishingPackageDetails(siteId, packageId);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<PublishingPackageDetails> result = new ResultOne<PublishingPackageDetails>();
        result.setEntity("package", publishingPackageDetails);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/cancel"})
    public ResponseBody cancelPublishingPackages(@RequestBody CancelPublishingPackagesRequest cancelPublishingPackagesRequest) throws SiteNotFoundException {
        String siteId = cancelPublishingPackagesRequest.getSiteId();
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        this.publishService.cancelPublishingPackages(siteId, cancelPublishingPackagesRequest.getPackageIds());
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/status"})
    public ResponseBody getPublishingStatus(@RequestParam(name="siteId") String siteId) throws SiteNotFoundException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        PublishStatus status = this.sitesService.getPublishingStatus(siteId);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<PublishStatus> result = new ResultOne<PublishStatus>();
        result.setEntity("publishingStatus", status);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/clear_lock"}, consumes={"application/json"})
    public ResponseBody clearPublishingLock(@RequestBody ClearPublishingLockRequest clearPublishingLockRequest) throws SiteNotFoundException {
        String siteId = clearPublishingLockRequest.getSiteId();
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        this.sitesService.clearPublishingLock(siteId);
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/history"}, produces={"application/json"})
    public ResponseBody getPublishingHistory(@RequestParam(name="siteId") String siteId, @RequestParam(name="days") int daysFromToday, @RequestParam(name="num") int numberOfItems, @RequestParam(name="filterType") String filterType) throws SiteNotFoundException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        List<DeploymentHistoryGroup> history = this.publishService.getDeploymentHistory(siteId, daysFromToday, numberOfItems, filterType);
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<DeploymentHistoryGroup> result = new PaginatedResultList<DeploymentHistoryGroup>();
        result.setResponse(ApiResponse.OK);
        result.setEntities("documents", history);
        result.setOffset(0);
        result.setLimit(history.size());
        result.setTotal(history.size());
        responseBody.setResult(result);
        return responseBody;
    }

    public PublishService getPublishService() {
        return this.publishService;
    }

    public void setPublishService(PublishService publishService) {
        this.publishService = publishService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SitesService getSitesService() {
        return this.sitesService;
    }

    public void setSitesService(SitesService sitesService) {
        this.sitesService = sitesService;
    }
}

