/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteNotRemovableException;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.DiffConflictedFile;
import org.craftercms.studio.api.v2.dal.RemoteRepository;
import org.craftercms.studio.api.v2.dal.RemoteRepositoryInfo;
import org.craftercms.studio.api.v2.dal.RepositoryStatus;
import org.craftercms.studio.api.v2.exception.PullFromRemoteConflictException;
import org.craftercms.studio.api.v2.service.repository.RepositoryManagementService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.CancelFailedPullRequest;
import org.craftercms.studio.model.rest.CommitResolutionRequest;
import org.craftercms.studio.model.rest.PullFromRemoteRequest;
import org.craftercms.studio.model.rest.PushToRemoteRequest;
import org.craftercms.studio.model.rest.RebuildDatabaseRequest;
import org.craftercms.studio.model.rest.RemoveRemoteRequest;
import org.craftercms.studio.model.rest.ResolveConflictRequest;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.Result;
import org.craftercms.studio.model.rest.ResultList;
import org.craftercms.studio.model.rest.ResultOne;
import org.craftercms.studio.model.rest.UnlockRepositoryRequest;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/repository"})
public class RepositoryManagementController {
    private RepositoryManagementService repositoryManagementService;
    private SiteService siteService;

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/add_remote"})
    public ResponseBody addRemote(HttpServletResponse response, @RequestBody RemoteRepository remoteRepository) throws ServiceLayerException, InvalidRemoteUrlException {
        if (!this.siteService.exists(remoteRepository.getSiteId())) {
            throw new SiteNotFoundException(remoteRepository.getSiteId());
        }
        boolean res = this.repositoryManagementService.addRemote(remoteRepository.getSiteId(), remoteRepository);
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        if (res) {
            result.setResponse(ApiResponse.CREATED);
        } else {
            result.setResponse(ApiResponse.ADD_REMOTE_INVALID);
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/list_remotes"}, produces={"application/json"})
    public ResponseBody listRemotes(@RequestParam(name="siteId", required=true) String siteId) throws ServiceLayerException, CryptoException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        List<RemoteRepositoryInfo> remotes = this.repositoryManagementService.listRemotes(siteId);
        ResponseBody responseBody = new ResponseBody();
        ResultList<RemoteRepositoryInfo> result = new ResultList<RemoteRepositoryInfo>();
        result.setEntities("remotes", remotes);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/pull_from_remote"})
    public ResponseBody pullFromRemote(@RequestBody PullFromRemoteRequest pullFromRemoteRequest) throws InvalidRemoteUrlException, ServiceLayerException, CryptoException {
        if (!this.siteService.exists(pullFromRemoteRequest.getSiteId())) {
            throw new SiteNotFoundException(pullFromRemoteRequest.getSiteId());
        }
        boolean res = this.repositoryManagementService.pullFromRemote(pullFromRemoteRequest.getSiteId(), pullFromRemoteRequest.getRemoteName(), pullFromRemoteRequest.getRemoteBranch(), pullFromRemoteRequest.getMergeStrategy());
        if (!res) {
            throw new PullFromRemoteConflictException("Pull from remote result is merge conflict.");
        }
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/push_to_remote"})
    public ResponseBody pushToRemote(HttpServletResponse response, @RequestBody PushToRemoteRequest pushToRemoteRequest) throws InvalidRemoteUrlException, CryptoException, ServiceLayerException {
        if (!this.siteService.exists(pushToRemoteRequest.getSiteId())) {
            throw new SiteNotFoundException(pushToRemoteRequest.getSiteId());
        }
        boolean res = this.repositoryManagementService.pushToRemote(pushToRemoteRequest.getSiteId(), pushToRemoteRequest.getRemoteName(), pushToRemoteRequest.getRemoteBranch(), pushToRemoteRequest.isForce());
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        if (res) {
            result.setResponse(ApiResponse.OK);
        } else {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            result.setResponse(ApiResponse.PUSH_TO_REMOTE_FAILED);
        }
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/rebuild_database"})
    public ResponseBody rebuildDatabase(@RequestBody RebuildDatabaseRequest rebuildDatabaseRequest) throws SiteNotFoundException {
        if (!this.siteService.exists(rebuildDatabaseRequest.getSiteId())) {
            throw new SiteNotFoundException(rebuildDatabaseRequest.getSiteId());
        }
        this.repositoryManagementService.rebuildDatabase(rebuildDatabaseRequest.getSiteId());
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/remove_remote"})
    public ResponseBody removeRemote(HttpServletResponse response, @RequestBody RemoveRemoteRequest removeRemoteRequest) throws CryptoException, SiteNotFoundException, RemoteNotRemovableException {
        if (!this.siteService.exists(removeRemoteRequest.getSiteId())) {
            throw new SiteNotFoundException(removeRemoteRequest.getSiteId());
        }
        boolean res = this.repositoryManagementService.removeRemote(removeRemoteRequest.getSiteId(), removeRemoteRequest.getRemoteName());
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        if (res) {
            result.setResponse(ApiResponse.OK);
        } else {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            result.setResponse(ApiResponse.REMOVE_REMOTE_FAILED);
        }
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/status"})
    public ResponseBody getRepositoryStatus(@RequestParam(value="siteId") String siteId) throws ServiceLayerException, CryptoException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        RepositoryStatus status = this.repositoryManagementService.getRepositoryStatus(siteId);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<RepositoryStatus> result = new ResultOne<RepositoryStatus>();
        result.setEntity("repositoryStatus", status);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/resolve_conflict"})
    public ResponseBody resolveConflict(@RequestBody ResolveConflictRequest resolveConflictRequest) throws ServiceLayerException, CryptoException {
        if (!this.siteService.exists(resolveConflictRequest.getSiteId())) {
            throw new SiteNotFoundException(resolveConflictRequest.getSiteId());
        }
        String path = resolveConflictRequest.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        RepositoryStatus status = this.repositoryManagementService.resolveConflict(resolveConflictRequest.getSiteId(), path, resolveConflictRequest.getResolution());
        ResponseBody responseBody = new ResponseBody();
        ResultOne<RepositoryStatus> result = new ResultOne<RepositoryStatus>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("repositoryStatus", status);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/diff_conflicted_file"})
    public ResponseBody getDiffForConflictedFile(@RequestParam(value="siteId") String siteId, @RequestParam(value="path") String path) throws ServiceLayerException, CryptoException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        String diffPath = path;
        if (!diffPath.startsWith("/")) {
            diffPath = "/" + diffPath;
        }
        DiffConflictedFile diff = this.repositoryManagementService.getDiffForConflictedFile(siteId, diffPath);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<DiffConflictedFile> result = new ResultOne<DiffConflictedFile>();
        result.setEntity("diff", diff);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/commit_resolution"})
    public ResponseBody commitConflictResolution(@RequestBody CommitResolutionRequest commitResolutionRequest) throws ServiceLayerException, CryptoException {
        if (!this.siteService.exists(commitResolutionRequest.getSiteId())) {
            throw new SiteNotFoundException(commitResolutionRequest.getSiteId());
        }
        RepositoryStatus status = this.repositoryManagementService.commitResolution(commitResolutionRequest.getSiteId(), commitResolutionRequest.getCommitMessage());
        ResponseBody responseBody = new ResponseBody();
        ResultOne<RepositoryStatus> result = new ResultOne<RepositoryStatus>();
        result.setEntity("repositoryStatus", status);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/cancel_failed_pull"})
    public ResponseBody cancelFailedPull(@RequestBody CancelFailedPullRequest cancelFailedPullRequest) throws ServiceLayerException, CryptoException {
        if (!this.siteService.exists(cancelFailedPullRequest.getSiteId())) {
            throw new SiteNotFoundException(cancelFailedPullRequest.getSiteId());
        }
        RepositoryStatus status = this.repositoryManagementService.cancelFailedPull(cancelFailedPullRequest.getSiteId());
        ResponseBody responseBody = new ResponseBody();
        ResultOne<RepositoryStatus> result = new ResultOne<RepositoryStatus>();
        result.setEntity("repositoryStatus", status);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/unlock"})
    public ResponseBody unlockRepository(@RequestBody UnlockRepositoryRequest unlockRepositoryRequest) throws CryptoException, SiteNotFoundException {
        boolean success = false;
        if (!StringUtils.isEmpty((CharSequence)unlockRepositoryRequest.getSiteId()) && !this.siteService.exists(unlockRepositoryRequest.getSiteId())) {
            throw new SiteNotFoundException("Site " + unlockRepositoryRequest.getSiteId() + " not found");
        }
        success = this.repositoryManagementService.unlockRepository(unlockRepositoryRequest.getSiteId(), GitRepositories.valueOf(unlockRepositoryRequest.getRepositoryType()));
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        if (success) {
            result.setResponse(ApiResponse.OK);
        } else {
            result.setResponse(ApiResponse.INTERNAL_SYSTEM_FAILURE);
        }
        responseBody.setResult(result);
        return responseBody;
    }

    public RepositoryManagementService getRepositoryManagementService() {
        return this.repositoryManagementService;
    }

    public void setRepositoryManagementService(RepositoryManagementService repositoryManagementService) {
        this.repositoryManagementService = repositoryManagementService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

