/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v2.service.search.SearchService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.ResultOne;
import org.craftercms.studio.model.search.SearchParams;
import org.craftercms.studio.model.search.SearchResult;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/search"})
public class SearchController {
    protected SearchService searchService;

    @Required
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @PostMapping(value={"/search"})
    public ResponseBody search(@RequestParam String siteId, @RequestBody SearchParams params) throws AuthenticationException, ServiceLayerException {
        SearchResult searchResult = this.searchService.search(siteId, params);
        ResultOne<SearchResult> result = new ResultOne<SearchResult>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("result", searchResult);
        ResponseBody body = new ResponseBody();
        body.setResult(result);
        return body;
    }
}

