/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v2.service.security.EncryptionService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.ResultOne;
import org.craftercms.studio.model.rest.security.EncryptRequest;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/security"})
public class SecurityController {
    protected EncryptionService encryptionService;

    public SecurityController(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    @PostMapping(value={"/encrypt"})
    public ResponseBody encryptText(@RequestBody EncryptRequest request) throws ServiceLayerException {
        String encrypted = this.encryptionService.encrypt(request.getSiteId(), request.getText());
        ResultOne<String> result = new ResultOne<String>();
        result.setEntity("item", encrypted);
        result.setResponse(ApiResponse.OK);
        ResponseBody response = new ResponseBody();
        response.setResult(result);
        return response;
    }
}

