/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.util.List;
import javax.validation.Valid;
import org.craftercms.commons.plugin.model.PluginDescriptor;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v2.service.marketplace.MarketplaceService;
import org.craftercms.studio.api.v2.service.site.SitesService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.Result;
import org.craftercms.studio.model.rest.ResultList;
import org.craftercms.studio.model.rest.marketplace.CreateSiteRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/sites"})
public class SitesController {
    private SitesService sitesService;
    private MarketplaceService marketplaceService;

    @GetMapping(value={"/available_blueprints"})
    public ResponseBody getAvailableBlueprints() throws ServiceLayerException {
        List<PluginDescriptor> blueprintDescriptors = null;
        try {
            blueprintDescriptors = this.sitesService.getAvailableBlueprints();
        }
        catch (Exception e) {
            throw new ServiceLayerException(e);
        }
        ResponseBody responseBody = new ResponseBody();
        ResultList<PluginDescriptor> result = new ResultList<PluginDescriptor>();
        result.setEntities("blueprints", blueprintDescriptors);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/create_site_from_marketplace"})
    public ResponseBody createSite(@Valid @RequestBody CreateSiteRequest request) throws RemoteRepositoryNotFoundException, InvalidRemoteRepositoryException, ServiceLayerException, InvalidRemoteRepositoryCredentialsException, InvalidRemoteUrlException, RemoteRepositoryNotBareException {
        this.marketplaceService.createSite(request);
        Result result = new Result();
        result.setResponse(ApiResponse.CREATED);
        ResponseBody response = new ResponseBody();
        response.setResult(result);
        return response;
    }

    public SitesService getSitesService() {
        return this.sitesService;
    }

    public void setSitesService(SitesService sitesService) {
        this.sitesService = sitesService;
    }

    public void setMarketplaceService(MarketplaceService marketplaceService) {
        this.marketplaceService = marketplaceService;
    }
}

