/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v2.exception.SystemToolException;
import org.craftercms.studio.api.v2.service.system.ToolsService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.Result;
import org.craftercms.studio.model.rest.ResultOne;
import org.craftercms.studio.model.rest.system.ExecuteDbQueryRequestBody;
import org.craftercms.studio.model.rest.system.ExecuteShellCommandRequestBody;
import org.craftercms.studio.model.rest.system.ShellCommandResponse;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/system"})
public class SystemToolsController {
    private static final Logger logger = LoggerFactory.getLogger(SystemToolsController.class);
    private ToolsService toolsService;
    private SecurityService securityService;
    private boolean enabled = false;

    public SystemToolsController(ToolsService toolsService, SecurityService securityService) {
        this.toolsService = toolsService;
        this.securityService = securityService;
    }

    @PostMapping(value={"/db/query"})
    public ResponseBody executeQuery(@RequestBody ExecuteDbQueryRequestBody requestBody) throws SQLException, ServiceLayerException, UserNotFoundException {
        if (!this.enabled) {
            throw new SystemToolException("System tool disabled");
        }
        logger.info("User " + this.securityService.getCurrentUser() + " requested to execute DB query \"" + requestBody.getQuery() + "\" via System Tools API", new Object[0]);
        List<Map<String, Object>> data = this.toolsService.executeDbQuery(requestBody.getQuery());
        ResponseBody responseBody = new ResponseBody();
        ResultOne<List<Map<String, Object>>> result = new ResultOne<List<Map<String, Object>>>();
        result.setEntity("data", data);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/shell/command"})
    public ResponseBody executeShellCommand(@RequestBody ExecuteShellCommandRequestBody requestBody) throws IOException, InterruptedException, ServiceLayerException, UserNotFoundException {
        if (!this.enabled) {
            throw new SystemToolException("System tool disabled");
        }
        logger.info("User " + this.securityService.getCurrentUser() + " requested to execute shell command \"" + requestBody.getCommand() + "\" via System Tools API", new Object[0]);
        logger.info("Working directory: " + (StringUtils.isEmpty((CharSequence)requestBody.getWorkingDirectory()) ? "CRAFTER_HOME" : requestBody.getWorkingDirectory()), new Object[0]);
        if (CollectionUtils.isNotEmpty(requestBody.getArguments())) {
            logger.info("Arguments: " + requestBody.getArguments().stream().collect(Collectors.joining(", ")), new Object[0]);
        }
        ShellCommandResponse res = this.toolsService.executeShellCommand(requestBody.getWorkingDirectory(), requestBody.getCommand(), requestBody.getArguments());
        ResponseBody responseBody = new ResponseBody();
        ResultOne<ShellCommandResponse> result = new ResultOne<ShellCommandResponse>();
        result.setEntity("result", res);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PatchMapping(value={"/tools/enable"})
    public ResponseBody enableTools() {
        this.setEnabled(true);
        logger.info("User " + this.securityService.getCurrentUser() + " enabled System Tools API", new Object[0]);
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PatchMapping(value={"/tools/disable"})
    public ResponseBody disableTools() {
        this.setEnabled(false);
        logger.info("User " + this.securityService.getCurrentUser() + " disabled System Tools API", new Object[0]);
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    private synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

