/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v2.service.ui.UiService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.ResultList;
import org.craftercms.studio.model.rest.ResultOne;
import org.craftercms.studio.model.ui.MenuItem;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/ui"})
public class UiController {
    private UiService uiService;

    @GetMapping(value={"/views/global_menu"})
    public ResponseBody getGlobalMenu() throws AuthenticationException, ServiceLayerException {
        ResultList<MenuItem> result = new ResultList<MenuItem>();
        result.setResponse(ApiResponse.OK);
        result.setEntities("menuItems", this.uiService.getGlobalMenu());
        ResponseBody responseBody = new ResponseBody();
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/system/active_environment"})
    public ResponseBody getActiveEnvironment() throws AuthenticationException {
        ResultOne<String> result = new ResultOne<String>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("environment", this.uiService.getActiveEnvironment());
        ResponseBody responseBody = new ResponseBody();
        responseBody.setResult(result);
        return responseBody;
    }

    @Required
    public void setUiService(UiService uiService) {
        this.uiService = uiService;
    }
}

