/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserExternallyManagedException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.service.security.GroupService;
import org.craftercms.studio.api.v2.service.security.UserService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.controller.rest.v2.ValidationUtils;
import org.craftercms.studio.impl.v2.utils.PaginationUtils;
import org.craftercms.studio.model.AuthenticatedUser;
import org.craftercms.studio.model.Site;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ChangePasswordRequest;
import org.craftercms.studio.model.rest.EnableUsers;
import org.craftercms.studio.model.rest.PaginatedResultList;
import org.craftercms.studio.model.rest.ResetPasswordRequest;
import org.craftercms.studio.model.rest.ResponseBody;
import org.craftercms.studio.model.rest.Result;
import org.craftercms.studio.model.rest.ResultList;
import org.craftercms.studio.model.rest.ResultOne;
import org.craftercms.studio.model.rest.SetPasswordRequest;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/users"})
public class UsersController {
    private static final Logger logger = LoggerFactory.getLogger(UsersController.class);
    private UserService userService;
    private GroupService groupService;
    private SiteService siteService;
    private StudioConfiguration studioConfiguration;

    @GetMapping
    public ResponseBody getAllUsers(@RequestParam(value="site_id", required=false) String siteId, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="10") int limit, @RequestParam(value="sort", required=false, defaultValue="") String sort) throws ServiceLayerException {
        List<User> users = null;
        int total = 0;
        if (StringUtils.isEmpty((CharSequence)siteId)) {
            total = this.userService.getAllUsersTotal();
            users = this.userService.getAllUsers(offset, limit, sort);
        } else {
            total = this.userService.getAllUsersForSiteTotal(1L, siteId);
            users = this.userService.getAllUsersForSite(1L, siteId, offset, limit, sort);
        }
        ResponseBody responseBody = new ResponseBody();
        PaginatedResultList<User> result = new PaginatedResultList<User>();
        result.setTotal(total);
        result.setOffset(offset);
        result.setLimit(CollectionUtils.isEmpty(users) ? 0 : users.size());
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        result.setEntities("users", users);
        return responseBody;
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={""}, consumes={"application/json"})
    public ResponseBody createUser(@RequestBody User user) throws UserAlreadyExistsException, ServiceLayerException, AuthenticationException {
        User newUser = this.userService.createUser(user);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<User> result = new ResultOne<User>();
        result.setResponse(ApiResponse.CREATED);
        result.setEntity("user", newUser);
        responseBody.setResult(result);
        return responseBody;
    }

    @PatchMapping(value={""}, consumes={"application/json"})
    public ResponseBody updateUser(@RequestBody User user) throws ServiceLayerException, UserNotFoundException, AuthenticationException {
        this.userService.updateUser(user);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<User> result = new ResultOne<User>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("user", user);
        responseBody.setResult(result);
        return responseBody;
    }

    @DeleteMapping
    public ResponseBody deleteUser(@RequestParam(value="id", required=false) List<Long> userIds, @RequestParam(value="username", required=false) List<String> usernames) throws ServiceLayerException, AuthenticationException, UserNotFoundException {
        ValidationUtils.validateAnyListNonEmpty(userIds, usernames);
        this.userService.deleteUsers(userIds != null ? userIds : Collections.emptyList(), usernames != null ? usernames : Collections.emptyList());
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.DELETED);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/{id}"}, consumes={"*/*"}, produces={"application/json"})
    public ResponseBody getUser(@PathVariable(value="id") String userId) throws ServiceLayerException, UserNotFoundException {
        int uId = -1;
        String username = "";
        if (StringUtils.isNumeric((CharSequence)userId)) {
            uId = Integer.parseInt(userId);
        } else {
            username = userId;
        }
        User user = this.userService.getUserByIdOrUsername(uId, username);
        ResponseBody responseBody = new ResponseBody();
        ResultOne<User> result = new ResultOne<User>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("user", user);
        responseBody.setResult(result);
        return responseBody;
    }

    @PatchMapping(value={"/enable"}, consumes={"application/json"})
    public ResponseBody enableUsers(@RequestBody EnableUsers enableUsers) throws ServiceLayerException, UserNotFoundException, AuthenticationException {
        ValidationUtils.validateEnableUsers(enableUsers);
        List<User> users = this.userService.enableUsers(enableUsers.getIds(), enableUsers.getUsernames(), true);
        ResponseBody responseBody = new ResponseBody();
        ResultList<User> result = new ResultList<User>();
        result.setResponse(ApiResponse.OK);
        result.setEntities("users", users);
        responseBody.setResult(result);
        return responseBody;
    }

    @PatchMapping(value={"/disable"}, consumes={"application/json"})
    public ResponseBody disableUsers(@RequestBody EnableUsers enableUsers) throws ServiceLayerException, UserNotFoundException, AuthenticationException {
        ValidationUtils.validateEnableUsers(enableUsers);
        List<User> users = this.userService.enableUsers(enableUsers.getIds(), enableUsers.getUsernames(), false);
        ResponseBody responseBody = new ResponseBody();
        ResultList<User> result = new ResultList<User>();
        result.setResponse(ApiResponse.OK);
        result.setEntities("users", users);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/{id}/sites"})
    public ResponseBody getUserSites(@PathVariable(value="id") String userId, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="10") int limit) throws ServiceLayerException, UserNotFoundException {
        int uId = -1;
        String username = "";
        if (StringUtils.isNumeric((CharSequence)userId)) {
            uId = Integer.parseInt(userId);
        } else {
            username = userId;
        }
        List<Site> allSites = this.userService.getUserSites(uId, username);
        List<Site> paginatedSites = PaginationUtils.paginate(allSites, offset, limit, "siteId");
        PaginatedResultList<Site> result = new PaginatedResultList<Site>();
        result.setResponse(ApiResponse.OK);
        result.setTotal(allSites.size());
        result.setOffset(offset);
        result.setLimit(limit);
        result.setEntities("sites", paginatedSites);
        ResponseBody responseBody = new ResponseBody();
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/{id}/sites/{site}/roles"})
    public ResponseBody getUserSiteRoles(@PathVariable(value="id") String userId, @PathVariable(value="site") String site) throws ServiceLayerException, UserNotFoundException {
        int uId = -1;
        String username = "";
        if (StringUtils.isNumeric((CharSequence)userId)) {
            uId = Integer.parseInt(userId);
        } else {
            username = userId;
        }
        List<String> roles = this.userService.getUserSiteRoles(uId, username, site);
        ResultList<String> result = new ResultList<String>();
        result.setResponse(ApiResponse.OK);
        result.setEntities("roles", roles);
        ResponseBody responseBody = new ResponseBody();
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/me"})
    public ResponseBody getCurrentUser() throws AuthenticationException, ServiceLayerException {
        AuthenticatedUser user = this.userService.getCurrentUser();
        ResultOne<AuthenticatedUser> result = new ResultOne<AuthenticatedUser>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("authenticatedUser", user);
        ResponseBody responseBody = new ResponseBody();
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/me/sites"})
    public ResponseBody getCurrentUserSites(@RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="10") int limit) throws AuthenticationException, ServiceLayerException {
        List<Site> allSites = this.userService.getCurrentUserSites();
        List<Site> paginatedSites = PaginationUtils.paginate(allSites, offset, limit, "siteId");
        PaginatedResultList<Site> result = new PaginatedResultList<Site>();
        result.setResponse(ApiResponse.OK);
        result.setTotal(allSites.size());
        result.setOffset(offset);
        result.setLimit(limit);
        result.setEntities("sites", paginatedSites);
        ResponseBody responseBody = new ResponseBody();
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/me/sites/{site}/roles"})
    public ResponseBody getCurrentUserSiteRoles(@PathVariable(value="site") String site) throws AuthenticationException, ServiceLayerException {
        List<String> roles = this.userService.getCurrentUserSiteRoles(site);
        ResultList<String> result = new ResultList<String>();
        result.setResponse(ApiResponse.OK);
        result.setEntities("roles", roles);
        ResponseBody responseBody = new ResponseBody();
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/me/logout/sso/url"})
    public ResponseBody getCurrentUserSsoLogoutUrl() throws ServiceLayerException, AuthenticationException {
        String logoutUrl = this.userService.getCurrentUserSsoLogoutUrl();
        ResultOne<String> result = new ResultOne<String>();
        result.setResponse(ApiResponse.OK);
        result.setEntity("logoutUrl", logoutUrl);
        ResponseBody responseBody = new ResponseBody();
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/forgot_password"})
    public ResponseBody forgotPassword(@RequestParam(value="username", required=true) String username) throws ServiceLayerException {
        try {
            this.userService.forgotPassword(username);
        }
        catch (UserExternallyManagedException | UserNotFoundException e) {
            logger.error("Error processing user's forgot password request", e, new Object[0]);
        }
        ResponseBody responseBody = new ResponseBody();
        ResultOne<String> result = new ResultOne<String>();
        result.setEntity("message", "If the user exists, a password recovery email has been sent to them.");
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/me/change_password"})
    public ResponseBody changePassword(@RequestBody ChangePasswordRequest changePasswordRequest) throws PasswordDoesNotMatchException, ServiceLayerException, UserExternallyManagedException, AuthenticationException, UserNotFoundException {
        User result = this.userService.changePassword(changePasswordRequest.getUsername(), changePasswordRequest.getCurrent(), changePasswordRequest.getNewPassword());
        ResponseBody responseBody = new ResponseBody();
        ResultOne<User> resultOne = new ResultOne<User>();
        resultOne.setEntity("user", result);
        resultOne.setResponse(ApiResponse.OK);
        responseBody.setResult(resultOne);
        return responseBody;
    }

    @PostMapping(value={"/set_password"})
    public ResponseBody setPassword(@RequestBody SetPasswordRequest setPasswordRequest) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException {
        int delay = this.studioConfiguration.getProperty("studio.security.setPasswordDelay", Integer.class);
        try {
            TimeUnit.SECONDS.sleep(delay);
        }
        catch (InterruptedException e) {
            logger.debug("Interrupted while delaying request by " + delay + " seconds.", e);
        }
        User user = this.userService.setPassword(setPasswordRequest.getToken(), setPasswordRequest.getNewPassword());
        ResponseBody responseBody = new ResponseBody();
        ResultOne<User> result = new ResultOne<User>();
        result.setEntity("user", user);
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @PostMapping(value={"/{id}/reset_password"})
    public ResponseBody resetPassword(@PathVariable(value="id") String userId, @RequestBody ResetPasswordRequest resetPasswordRequest) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException {
        this.userService.resetPassword(resetPasswordRequest.getUsername(), resetPasswordRequest.getNewPassword());
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        result.setResponse(ApiResponse.OK);
        responseBody.setResult(result);
        return responseBody;
    }

    @GetMapping(value={"/validate_token"}, produces={"application/json"})
    public ResponseBody validateToken(HttpServletResponse response, @RequestParam(value="token", required=true) String token) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException {
        int delay = this.studioConfiguration.getProperty("studio.security.setPasswordDelay", Integer.class);
        try {
            TimeUnit.SECONDS.sleep(delay);
        }
        catch (InterruptedException e) {
            logger.debug("Interrupted while delaying request by " + delay + " seconds.", e);
        }
        boolean valid = this.userService.validateToken(token);
        ResponseBody responseBody = new ResponseBody();
        Result result = new Result();
        if (valid) {
            result.setResponse(ApiResponse.OK);
        } else {
            result.setResponse(ApiResponse.UNAUTHORIZED);
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        }
        responseBody.setResult(result);
        return responseBody;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

