/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.craftercms.studio.api.v2.exception.InvalidParametersException;
import org.craftercms.studio.model.rest.AddGroupMembers;
import org.craftercms.studio.model.rest.EnableUsers;
import org.springframework.util.CollectionUtils;

public abstract class ValidationUtils {
    public static void validateAnyListNonEmpty(List<?> ... lists) throws InvalidParametersException {
        long validLists = Arrays.stream(lists).filter(Objects::nonNull).filter(list -> !list.isEmpty()).count();
        if (validLists == 0L) {
            throw new InvalidParametersException("All parameters are empty or null");
        }
    }

    public static void validateAddGroupMembers(AddGroupMembers addGroupMembers) throws InvalidParametersException {
        if (CollectionUtils.isEmpty(addGroupMembers.getIds()) && CollectionUtils.isEmpty(addGroupMembers.getUsernames())) {
            throw new InvalidParametersException("Both 'userIds' and 'usernames' are empty");
        }
    }

    public static void validateEnableUsers(EnableUsers enableUsers) throws InvalidParametersException {
        if (CollectionUtils.isEmpty(enableUsers.getIds()) && CollectionUtils.isEmpty(enableUsers.getUsernames())) {
            throw new InvalidParametersException("Both 'userIds' and 'usernames' are empty");
        }
    }
}

