/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.WebDavException;
import org.craftercms.studio.api.v1.webdav.WebDavItem;
import org.craftercms.studio.api.v2.exception.InvalidParametersException;
import org.craftercms.studio.api.v2.service.webdav.WebDavService;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResultList;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/webdav"})
public class WebdavController {
    protected WebDavService webDavService;

    public WebdavController(WebDavService webDavService) {
        this.webDavService = webDavService;
    }

    @GetMapping(value={"list"})
    public ResultList<WebDavItem> listItems(@RequestParam(value="siteId") String siteId, @RequestParam(value="profileId") String profileId, @RequestParam(value="path", required=false, defaultValue="") String path, @RequestParam(value="type", required=false, defaultValue="") String type) throws WebDavException {
        ResultList<WebDavItem> result = new ResultList<WebDavItem>();
        result.setEntities("items", this.webDavService.list(siteId, profileId, path, type));
        result.setResponse(ApiResponse.OK);
        return result;
    }

    @PostMapping(value={"/upload"})
    public ResultOne<WebDavItem> uploadItem(HttpServletRequest request) throws IOException, WebDavException, InvalidParametersException {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ResultOne<WebDavItem> result = new ResultOne<WebDavItem>();
            try {
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iterator = upload.getItemIterator(request);
                String siteId = null;
                String profileId = null;
                String path = null;
                if (!iterator.hasNext()) {
                    throw new InvalidParametersException("Request body is empty");
                }
                while (iterator.hasNext()) {
                    FileItemStream item = iterator.next();
                    String name = item.getFieldName();
                    InputStream stream = item.openStream();
                    Throwable throwable = null;
                    try {
                        if (item.isFormField()) {
                            switch (name) {
                                case "siteId": {
                                    siteId = Streams.asString((InputStream)stream);
                                    break;
                                }
                                case "profileId": {
                                    profileId = Streams.asString((InputStream)stream);
                                    break;
                                }
                                case "path": {
                                    path = Streams.asString((InputStream)stream);
                                }
                            }
                            continue;
                        }
                        String filename = item.getName();
                        if (StringUtils.isNotEmpty((CharSequence)filename)) {
                            filename = FilenameUtils.getName((String)filename);
                        }
                        result.setEntity("item", this.webDavService.upload(siteId, profileId, path, filename, stream));
                        result.setResponse(ApiResponse.OK);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                return result;
            }
            catch (FileUploadException e) {
                throw new InvalidParametersException("The request body is invalid");
            }
        }
        throw new InvalidParametersException("The request is not multipart");
    }
}

