/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2.aws;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.AwsException;
import org.craftercms.studio.api.v2.exception.InvalidParametersException;
import org.craftercms.studio.api.v2.service.aws.mediaconvert.AwsMediaConvertService;
import org.craftercms.studio.model.aws.mediaconvert.MediaConvertResult;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/aws/mediaconvert"})
public class AwsMediaConvertController {
    public static final String INPUT_PROFILE_PARAM = "inputProfileId";
    public static final String OUTPUT_PROFILE_PARAM = "outputProfileId";
    @Autowired
    protected AwsMediaConvertService mediaConvertService;

    @PostMapping(value={"/upload"})
    public ResultOne<MediaConvertResult> uploadVideo(HttpServletRequest request) throws IOException, AwsException, InvalidParametersException {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ResultOne<MediaConvertResult> result = new ResultOne<MediaConvertResult>();
            try {
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iterator = upload.getItemIterator(request);
                String siteId = null;
                String inputProfileId = null;
                String outputProfileId = null;
                while (iterator.hasNext()) {
                    FileItemStream item = iterator.next();
                    String name = item.getFieldName();
                    InputStream stream = item.openStream();
                    Throwable throwable = null;
                    try {
                        if (item.isFormField()) {
                            switch (name) {
                                case "siteId": {
                                    siteId = Streams.asString((InputStream)stream);
                                    break;
                                }
                                case "inputProfileId": {
                                    inputProfileId = Streams.asString((InputStream)stream);
                                    break;
                                }
                                case "outputProfileId": {
                                    outputProfileId = Streams.asString((InputStream)stream);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{siteId, inputProfileId, outputProfileId})) {
                            throw new InvalidParametersException("Missing one or more required parameters: siteId, inputProfileId or outputProfileId");
                        }
                        String filename = item.getName();
                        if (StringUtils.isNotEmpty((CharSequence)filename)) {
                            filename = FilenameUtils.getName((String)filename);
                        }
                        result.setEntity("item", this.mediaConvertService.uploadVideo(siteId, inputProfileId, outputProfileId, filename, stream));
                        result.setResponse(ApiResponse.OK);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                return result;
            }
            catch (FileUploadException e) {
                throw new InvalidParametersException("The request body is invalid");
            }
        }
        throw new InvalidParametersException("The request is not multipart");
    }
}

