/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.controller.rest.v2.aws;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.AwsException;
import org.craftercms.studio.api.v2.exception.InvalidParametersException;
import org.craftercms.studio.api.v2.service.aws.s3.AwsS3Service;
import org.craftercms.studio.model.aws.s3.S3Item;
import org.craftercms.studio.model.rest.ApiResponse;
import org.craftercms.studio.model.rest.ResultList;
import org.craftercms.studio.model.rest.ResultOne;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/2/aws/s3"})
public class AwsS3Controller {
    @Autowired
    protected AwsS3Service s3Service;

    @GetMapping(value={"/list"})
    public ResultList<S3Item> listItems(@RequestParam(value="siteId") String siteId, @RequestParam(value="profileId") String profileId, @RequestParam(value="path", required=false, defaultValue="") String path, @RequestParam(value="type", required=false, defaultValue="") String type) throws AwsException {
        ResultList<S3Item> result = new ResultList<S3Item>();
        result.setEntities("items", this.s3Service.listItems(siteId, profileId, path, type));
        result.setResponse(ApiResponse.OK);
        return result;
    }

    @PostMapping(value={"/upload"})
    public ResultOne<S3Item> uploadItem(HttpServletRequest request) throws IOException, InvalidParametersException, AwsException {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ResultOne<S3Item> result = new ResultOne<S3Item>();
            try {
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iterator = upload.getItemIterator(request);
                String siteId = null;
                String profileId = null;
                String path = null;
                while (iterator.hasNext()) {
                    FileItemStream item = iterator.next();
                    String name = item.getFieldName();
                    InputStream stream = item.openStream();
                    Throwable throwable = null;
                    try {
                        if (item.isFormField()) {
                            switch (name) {
                                case "siteId": {
                                    siteId = Streams.asString((InputStream)stream);
                                    break;
                                }
                                case "profileId": {
                                    profileId = Streams.asString((InputStream)stream);
                                    break;
                                }
                                case "path": {
                                    path = Streams.asString((InputStream)stream);
                                }
                            }
                            continue;
                        }
                        String filename = item.getName();
                        if (StringUtils.isNotEmpty((CharSequence)filename)) {
                            filename = FilenameUtils.getName((String)filename);
                        }
                        result.setEntity("item", this.s3Service.uploadItem(siteId, profileId, path, filename, stream));
                        result.setResponse(ApiResponse.OK);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                return result;
            }
            catch (FileUploadException e) {
                throw new InvalidParametersException("The request body is invalid");
            }
        }
        throw new InvalidParametersException("The request is not multipart");
    }
}

