/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.asset.processing;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.asset.Asset;
import org.craftercms.studio.api.v1.asset.processing.AssetProcessor;
import org.craftercms.studio.api.v1.asset.processing.ProcessorConfiguration;
import org.craftercms.studio.api.v1.exception.AssetProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAssetProcessor
implements AssetProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAssetProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Asset processAsset(ProcessorConfiguration config, Matcher inputPathMatcher, Asset input) throws AssetProcessingException {
        try {
            String outputRepoPath = this.getOutputRepoPath(config, inputPathMatcher);
            if (StringUtils.isEmpty((CharSequence)outputRepoPath)) {
                Path inputFilePath = this.moveToTmpFile(input.getRepoPath(), input.getFilePath());
                Path outputFilePath = input.getFilePath();
                Asset output = new Asset(input.getRepoPath(), outputFilePath);
                logger.info("Asset processing: Type = {}, Input = {}, Output = {}", new Object[]{config.getType(), input, output});
                try {
                    this.doProcessAsset(inputFilePath, outputFilePath, config.getParams());
                }
                finally {
                    Files.delete(inputFilePath);
                }
                return output;
            }
            Path inputFilePath = input.getFilePath();
            Path outputFilePath = this.createTmpFile(outputRepoPath);
            Asset output = new Asset(outputRepoPath, outputFilePath);
            logger.info("Asset processing: Type = {}, Input = {}, Output = {}", new Object[]{config.getType(), input, output});
            this.doProcessAsset(inputFilePath, outputFilePath, config.getParams());
            return output;
        }
        catch (Exception e) {
            throw new AssetProcessingException("Error while executing asset processor of type '" + config.getType() + "'", e);
        }
    }

    private Path moveToTmpFile(String repoPath, Path filePath) throws IOException {
        Path tmpFilePath = this.createTmpFile(repoPath);
        return Files.move(filePath, tmpFilePath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    private Path createTmpFile(String repoPath) throws IOException {
        return Files.createTempFile(FilenameUtils.getBaseName((String)repoPath), "." + FilenameUtils.getExtension((String)repoPath), new FileAttribute[0]);
    }

    protected String getOutputRepoPath(ProcessorConfiguration config, Matcher inputPathMatcher) {
        if (StringUtils.isNotEmpty((CharSequence)config.getOutputPathFormat())) {
            int groupCount = inputPathMatcher.groupCount();
            String outputPath = config.getOutputPathFormat();
            for (int i = 1; i <= groupCount; ++i) {
                outputPath = outputPath.replace("$" + i, inputPathMatcher.group(i));
            }
            return outputPath;
        }
        return null;
    }

    protected abstract void doProcessAsset(Path var1, Path var2, Map<String, String> var3) throws Exception;
}

