/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.asset.processing;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.asset.processing.AssetProcessingConfigReader;
import org.craftercms.studio.api.v1.asset.processing.ProcessorConfiguration;
import org.craftercms.studio.api.v1.asset.processing.ProcessorPipelineConfiguration;
import org.craftercms.studio.api.v1.exception.AssetProcessingConfigurationException;
import org.craftercms.studio.impl.v1.util.ConfigUtils;

public class AssetProcessingConfigReaderImpl
implements AssetProcessingConfigReader {
    public static final String PIPELINES_CONFIG_KEY = "pipelines.pipeline";
    public static final String INPUT_PATH_PATTERN_CONFIG_KEY = "inputPathPattern";
    public static final String KEEP_ORIGINAL_CONFIG_KEY = "keepOriginal";
    public static final String PROCESSORS_CONFIG_KEY = "processors.processor";
    public static final String PROCESSOR_TYPE_CONFIG_KEY = "type";
    public static final String PROCESSOR_PARAMS_CONFIG_KEY = "params";
    public static final String PROCESSOR_OUTPUT_PATH_FORMAT_CONFIG_KEY = "outputPathFormat";

    @Override
    public List<ProcessorPipelineConfiguration> readConfig(InputStream in) throws AssetProcessingConfigurationException {
        HierarchicalConfiguration<ImmutableNode> config;
        try {
            config = ConfigUtils.readXmlConfiguration(in);
        }
        catch (ConfigurationException e) {
            throw new AssetProcessingConfigurationException("Unable to read XML configuration file", (Exception)((Object)e));
        }
        return this.readConfig(config);
    }

    @Override
    public List<ProcessorPipelineConfiguration> readConfig(HierarchicalConfiguration config) throws AssetProcessingConfigurationException {
        List pipelinesConfig = config.configurationsAt(PIPELINES_CONFIG_KEY);
        if (CollectionUtils.isNotEmpty((Collection)pipelinesConfig)) {
            ArrayList<ProcessorPipelineConfiguration> mappedPipelinesConfig = new ArrayList<ProcessorPipelineConfiguration>(pipelinesConfig.size());
            for (HierarchicalConfiguration pipelineConfig : pipelinesConfig) {
                mappedPipelinesConfig.add(this.readPipelineConfig(pipelineConfig));
            }
            return mappedPipelinesConfig;
        }
        return Collections.emptyList();
    }

    private ProcessorPipelineConfiguration readPipelineConfig(HierarchicalConfiguration pipelineConfig) throws AssetProcessingConfigurationException {
        ProcessorPipelineConfiguration mappedPipelineConfig = new ProcessorPipelineConfiguration();
        mappedPipelineConfig.setInputPathPattern(this.getRequiredStringProperty((Configuration)pipelineConfig, INPUT_PATH_PATTERN_CONFIG_KEY));
        mappedPipelineConfig.setKeepOriginal(pipelineConfig.getBoolean(KEEP_ORIGINAL_CONFIG_KEY, false));
        List<HierarchicalConfiguration> processorsConfig = this.getRequiredConfigurationsAt(pipelineConfig, PROCESSORS_CONFIG_KEY);
        ArrayList<ProcessorConfiguration> mappedProcessorsConfig = new ArrayList<ProcessorConfiguration>(processorsConfig.size());
        for (HierarchicalConfiguration processorConfig : processorsConfig) {
            mappedProcessorsConfig.add(this.readProcessorConfig(processorConfig));
        }
        mappedPipelineConfig.setProcessorsConfig(mappedProcessorsConfig);
        return mappedPipelineConfig;
    }

    private ProcessorConfiguration readProcessorConfig(HierarchicalConfiguration processorConfig) throws AssetProcessingConfigurationException {
        ProcessorConfiguration mappedProcessorConfig = new ProcessorConfiguration();
        mappedProcessorConfig.setType(this.getRequiredStringProperty((Configuration)processorConfig, PROCESSOR_TYPE_CONFIG_KEY));
        mappedProcessorConfig.setParams(this.getProcessorParams(processorConfig));
        mappedProcessorConfig.setOutputPathFormat(processorConfig.getString(PROCESSOR_OUTPUT_PATH_FORMAT_CONFIG_KEY));
        return mappedProcessorConfig;
    }

    private Map<String, String> getProcessorParams(HierarchicalConfiguration processorConfig) {
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator keysIter = processorConfig.getKeys();
        String paramsPrefix = "params.";
        while (keysIter.hasNext()) {
            String key = (String)keysIter.next();
            if (!key.startsWith(paramsPrefix)) continue;
            String paramName = StringUtils.substringAfter((String)key, (String)paramsPrefix);
            String paramValue = processorConfig.getString(key);
            params.put(paramName, paramValue);
        }
        return params;
    }

    private List<HierarchicalConfiguration> getRequiredConfigurationsAt(HierarchicalConfiguration config, String key) throws AssetProcessingConfigurationException {
        List configs = config.configurationsAt(key);
        if (CollectionUtils.isEmpty((Collection)configs)) {
            throw new AssetProcessingConfigurationException("Missing required property '" + key + "'");
        }
        return configs;
    }

    private String getRequiredStringProperty(Configuration config, String key) throws AssetProcessingConfigurationException {
        String property = config.getString(key);
        if (StringUtils.isEmpty((CharSequence)property)) {
            throw new AssetProcessingConfigurationException("Missing required property '" + key + "'");
        }
        return property;
    }
}

