/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.asset.processing;

import org.craftercms.studio.api.v1.asset.processing.AssetProcessor;
import org.craftercms.studio.api.v1.asset.processing.AssetProcessorResolver;
import org.craftercms.studio.api.v1.asset.processing.ProcessorConfiguration;
import org.craftercms.studio.api.v1.exception.AssetProcessingConfigurationException;
import org.craftercms.studio.api.v1.exception.AssetProcessingException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AssetProcessorResolverImpl
implements AssetProcessorResolver,
ApplicationContextAware {
    private String beanNameFormat;
    private ApplicationContext applicationContext;

    @Required
    public void setBeanNameFormat(String beanNameFormat) {
        this.beanNameFormat = beanNameFormat;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public AssetProcessor getProcessor(ProcessorConfiguration config) throws AssetProcessingException {
        String beanName = String.format(this.beanNameFormat, config.getType());
        AssetProcessor processor = (AssetProcessor)this.applicationContext.getBean(beanName, AssetProcessor.class);
        if (processor != null) {
            return processor;
        }
        throw new AssetProcessingConfigurationException("Invalid processor type: " + config.getType());
    }
}

