/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.aws.elastictranscoder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.ConfigurationResolver;
import org.craftercms.commons.config.profiles.aws.AbstractAwsProfile;
import org.craftercms.commons.config.profiles.aws.AbstractAwsProfileMapper;
import org.craftercms.studio.api.v1.aws.elastictranscoder.TranscoderOutput;
import org.craftercms.studio.api.v1.aws.elastictranscoder.TranscoderProfile;

public class TranscoderProfileMapper
extends AbstractAwsProfileMapper<TranscoderProfile> {
    public static final String SERVICE_NAME = "elasticTranscoder";

    public TranscoderProfileMapper(ConfigurationResolver resolver) {
        super(SERVICE_NAME, resolver);
    }

    protected TranscoderProfile mapProfile(HierarchicalConfiguration<ImmutableNode> profileConfig) throws ConfigurationException {
        TranscoderProfile profile = (TranscoderProfile)super.mapProfile(profileConfig);
        profile.setPipelineId(ConfigUtils.getRequiredStringProperty(profileConfig, (String)"pipelineId"));
        List outputConfigs = ConfigUtils.getRequiredConfigurationsAt(profileConfig, (String)"outputs.output");
        ArrayList<TranscoderOutput> outputs = new ArrayList<TranscoderOutput>();
        for (HierarchicalConfiguration outputConfig : outputConfigs) {
            TranscoderOutput output = new TranscoderOutput();
            output.setPresetId(ConfigUtils.getRequiredStringProperty((Configuration)outputConfig, (String)"presetId"));
            output.setOutputKeySuffix(ConfigUtils.getRequiredStringProperty((Configuration)outputConfig, (String)"outputKeySuffix"));
            output.setThumbnailSuffixFormat(ConfigUtils.getStringProperty((Configuration)outputConfig, (String)"thumbnailSuffixFormat"));
            outputs.add(output);
        }
        profile.setOutputs(outputs);
        return profile;
    }

    protected AbstractAwsProfile createProfile() {
        return new TranscoderProfile();
    }
}

