/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.aws.mediaconvert;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.mediaconvert.AWSMediaConvert;
import com.amazonaws.services.mediaconvert.AWSMediaConvertClientBuilder;
import com.amazonaws.services.mediaconvert.model.CreateJobRequest;
import com.amazonaws.services.mediaconvert.model.CreateJobResult;
import com.amazonaws.services.mediaconvert.model.GetJobTemplateRequest;
import com.amazonaws.services.mediaconvert.model.Input;
import com.amazonaws.services.mediaconvert.model.JobSettings;
import com.amazonaws.services.mediaconvert.model.JobTemplate;
import com.amazonaws.services.mediaconvert.model.OutputGroup;
import com.amazonaws.services.mediaconvert.model.OutputGroupType;
import com.amazonaws.services.s3.AmazonS3;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.craftercms.commons.config.profiles.aws.AbstractAwsProfile;
import org.craftercms.commons.file.stores.S3Utils;
import org.craftercms.studio.api.v1.aws.mediaconvert.MediaConvert;
import org.craftercms.studio.api.v1.aws.mediaconvert.MediaConvertJob;
import org.craftercms.studio.api.v1.aws.mediaconvert.MediaConvertProfile;
import org.craftercms.studio.api.v1.exception.AwsException;
import org.craftercms.studio.impl.v1.service.aws.AwsUtils;

public class MediaConvertImpl
implements MediaConvert {
    protected int partSize = 0x500000;

    public void setPartSize(int partSize) {
        this.partSize = partSize;
    }

    protected AmazonS3 getS3Client(MediaConvertProfile profile) {
        return S3Utils.createClient((AbstractAwsProfile)profile);
    }

    protected AWSMediaConvert getMediaConvertClient(MediaConvertProfile profile) {
        return (AWSMediaConvert)((AWSMediaConvertClientBuilder)((AWSMediaConvertClientBuilder)AWSMediaConvertClientBuilder.standard().withCredentials(profile.getCredentialsProvider())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(profile.getEndpoint(), profile.getRegion()))).build();
    }

    protected MediaConvertJob createMediaConverJob(CreateJobResult createJobResult, String destination, String key) {
        MediaConvertJob job = new MediaConvertJob();
        job.setArn(createJobResult.getJob().getArn());
        job.setId(createJobResult.getJob().getId());
        job.setDestination(destination);
        job.setBaseKey(key);
        return job;
    }

    @Override
    public MediaConvertJob startJob(String filename, InputStream content, MediaConvertProfile profile) throws AwsException {
        AmazonS3 s3Client = this.getS3Client(profile);
        AWSMediaConvert mediaConvertClient = this.getMediaConvertClient(profile);
        AwsUtils.uploadStream(profile.getInputPath(), filename, s3Client, this.partSize, filename, content);
        String key = FilenameUtils.getBaseName((String)filename);
        JobTemplate jobTemplate = mediaConvertClient.getJobTemplate(new GetJobTemplateRequest().withName(profile.getTemplate())).getJobTemplate();
        JobSettings jobSettings = new JobSettings().withInputs(new Input[]{new Input().withFileInput(AwsUtils.getS3Url(profile.getInputPath(), filename))});
        CreateJobRequest createJobRequest = new CreateJobRequest().withJobTemplate(profile.getTemplate()).withSettings(jobSettings).withRole(profile.getRole()).withQueue(profile.getQueue());
        CreateJobResult createJobResult = mediaConvertClient.createJob(createJobRequest);
        return this.createMediaConverJob(createJobResult, this.getJobDestination(jobTemplate), key);
    }

    protected String getJobDestination(JobTemplate jobTemplate) {
        OutputGroup outputGroup = (OutputGroup)jobTemplate.getSettings().getOutputGroups().get(0);
        OutputGroupType type = OutputGroupType.valueOf((String)outputGroup.getOutputGroupSettings().getType());
        switch (type) {
            case FILE_GROUP_SETTINGS: {
                return outputGroup.getOutputGroupSettings().getFileGroupSettings().getDestination();
            }
            case HLS_GROUP_SETTINGS: {
                return outputGroup.getOutputGroupSettings().getHlsGroupSettings().getDestination();
            }
            case CMAF_GROUP_SETTINGS: {
                return outputGroup.getOutputGroupSettings().getCmafGroupSettings().getDestination();
            }
            case DASH_ISO_GROUP_SETTINGS: {
                return outputGroup.getOutputGroupSettings().getDashIsoGroupSettings().getDestination();
            }
            case MS_SMOOTH_GROUP_SETTINGS: {
                return outputGroup.getOutputGroupSettings().getMsSmoothGroupSettings().getDestination();
            }
        }
        return null;
    }
}

