/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.aws.mediaconvert;

import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.ConfigurationResolver;
import org.craftercms.commons.config.profiles.aws.AbstractAwsProfile;
import org.craftercms.commons.config.profiles.aws.AbstractAwsProfileMapper;
import org.craftercms.studio.api.v1.aws.mediaconvert.MediaConvertProfile;

public class MediaConvertProfileMapper
extends AbstractAwsProfileMapper<MediaConvertProfile> {
    public static final String CONFIG_KEY_MEDIACONVERT = "mediaConvert";
    public static final String CONFIG_KEY_ENDPOINT = "endpoint";
    public static final String CONFIG_KEY_ROLE = "role";
    public static final String CONFIG_KEY_QUEUE = "queue";
    public static final String CONFIG_KEY_TEMPLATE = "template";
    public static final String CONFIG_KEY_INPUT_PATH = "inputPath";

    public MediaConvertProfileMapper(ConfigurationResolver resolver) {
        super(CONFIG_KEY_MEDIACONVERT, resolver);
    }

    protected MediaConvertProfile mapProfile(HierarchicalConfiguration<ImmutableNode> profileConfig) throws ConfigurationException {
        MediaConvertProfile profile = (MediaConvertProfile)super.mapProfile(profileConfig);
        profile.setEndpoint(ConfigUtils.getRequiredStringProperty(profileConfig, (String)CONFIG_KEY_ENDPOINT));
        profile.setRole(ConfigUtils.getRequiredStringProperty(profileConfig, (String)CONFIG_KEY_ROLE));
        profile.setQueue(ConfigUtils.getRequiredStringProperty(profileConfig, (String)CONFIG_KEY_QUEUE));
        profile.setTemplate(ConfigUtils.getRequiredStringProperty(profileConfig, (String)CONFIG_KEY_TEMPLATE));
        profile.setInputPath(ConfigUtils.getRequiredStringProperty(profileConfig, (String)CONFIG_KEY_INPUT_PATH));
        return profile;
    }

    protected AbstractAwsProfile createProfile() {
        return new MediaConvertProfile();
    }
}

