/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.ContentProcessor;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.to.ResultTO;

public class BaseContentProcessor
implements ContentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BaseContentProcessor.class);
    public static final String NAME = "BaseContentProcessor";
    protected String _name;

    public BaseContentProcessor() {
        this._name = NAME;
    }

    public BaseContentProcessor(String name) {
        this._name = name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isProcessable(PipelineContent content) {
        return true;
    }

    @Override
    public void process(PipelineContent content, ResultTO result) throws ContentProcessException, SiteNotFoundException {
        logger.debug("Processing " + content.getId() + " through " + this._name, new Object[0]);
    }

    public void checkForMandatoryParam(String key, String value) throws ContentProcessException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new ContentProcessException(key + " is a mandatory parameter.");
        }
    }
}

