/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.DmContentLifeCycleService;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.PathMatchProcessor;

public class ContentLifeCycleProcessor
extends PathMatchProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ContentLifeCycleProcessor.class);
    protected DmContentLifeCycleService dmContentLifeCycleService;

    @Override
    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        String preview = content.getProperty("isPreview");
        if (StringUtils.isEmpty((CharSequence)preview) || !preview.equalsIgnoreCase("true")) {
            String site = content.getProperty("site");
            String folderPath = content.getProperty("folderPath");
            String contentType = content.getProperty("contentType");
            String fileName = content.getProperty("fileName");
            String path = folderPath.endsWith("/") ? folderPath + fileName : folderPath + "/" + fileName;
            String user = content.getProperty("user");
            String operValue = content.getProperty("contentLifecycleOperation");
            DmContentLifeCycleService.ContentLifeCycleOperation operation = DmContentLifeCycleService.ContentLifeCycleOperation.getOperation(operValue);
            if (operation == null) {
                String type = content.getProperty("activityType");
                operation = "CREATE".equals(type) ? DmContentLifeCycleService.ContentLifeCycleOperation.NEW : DmContentLifeCycleService.ContentLifeCycleOperation.UPDATE;
            }
            this.dmContentLifeCycleService.process(site, user, path, contentType, operation, null);
        }
    }

    public DmContentLifeCycleService getDmContentLifeCycleService() {
        return this.dmContentLifeCycleService;
    }

    public void setDmContentLifeCycleService(DmContentLifeCycleService dmContentLifeCycleService) {
        this.dmContentLifeCycleService = dmContentLifeCycleService;
    }
}

