/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.impl.v1.content.pipeline.PathMatchProcessor;

public class ExtractAssetDependencyProcessor
extends PathMatchProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExtractAssetDependencyProcessor.class);
    public static final String NAME = "ExtractAssetDependencyProcessor";
    protected ServicesConfig servicesConfig;
    protected DependencyService dependencyService;

    public ExtractAssetDependencyProcessor() {
        super(NAME);
    }

    public ExtractAssetDependencyProcessor(String name) {
        super(name);
    }

    @Override
    public void process(PipelineContent content, ResultTO result) throws ContentProcessException {
        String site = content.getProperty("site");
        String folderPath = content.getProperty("folderPath");
        String fileName = content.getProperty("fileName");
        String path = folderPath.endsWith("/") ? folderPath + fileName : folderPath + "/" + fileName;
        try {
            this.dependencyService.upsertDependencies(site, path);
        }
        catch (ServiceLayerException e) {
            throw new ContentProcessException(e);
        }
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }
}

